package magick;


/**
 * Corresponds to the ImageMagick enumerated type of the same name.
 * Important! Constant values should correspond to:
 * http://git.imagemagick.org/repos/ImageMagick/blob/master/MagickCore/effect.h
 * @author Eric Yeo
 */
public interface PreviewType {

    public final static int UndefinedPreview = 0;
    public final static int RotatePreview = 1;
    public final static int ShearPreview = 2;
    public final static int RollPreview = 3;
    public final static int HuePreview = 4;
    public final static int SaturationPreview = 5;
    public final static int BrightnessPreview = 6;
    public final static int GammaPreview = 7;
    public final static int SpiffPreview = 8;
    public final static int DullPreview = 9;
    public final static int GrayscalePreview = 10;
    public final static int QuantizePreview = 11;
    public final static int DespecklePreview = 12;
    public final static int ReduceNoisePreview = 13;
    public final static int AddNoisePreview = 14;
    public final static int SharpenPreview = 15;
    public final static int BlurPreview = 16;
    public final static int ThresholdPreview = 17;
    public final static int EdgeDetectPreview = 18;
    public final static int SpreadPreview = 19;
    public final static int SolarizePreview = 20;
    public final static int ShadePreview = 21;
    public final static int RaisePreview = 22;
    public final static int SegmentPreview = 23;
    public final static int SwirlPreview = 24;
    public final static int ImplodePreview = 25;
    public final static int WavePreview = 26;
    public final static int OilPaintPreview = 27;
    public final static int CharcoalDrawingPreview = 28;
    public final static int JPEGPreview = 29;

}
