/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.platform.yui.compressor;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptIdentifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

class ScriptOrFnScope {
    private int braceNesting;
    private ScriptOrFnScope parentScope;
    private ArrayList subScopes;
    private Hashtable identifiers = new Hashtable();
    private Hashtable hints = new Hashtable();
    private boolean markedForMunging = true;

    ScriptOrFnScope(int braceNesting, ScriptOrFnScope parentScope) {
        this.braceNesting = braceNesting;
        this.parentScope = parentScope;
        this.subScopes = new ArrayList();
        if (parentScope != null) {
            parentScope.subScopes.add(this);
        }
    }

    int getBraceNesting() {
        return this.braceNesting;
    }

    ScriptOrFnScope getParentScope() {
        return this.parentScope;
    }

    JavaScriptIdentifier declareIdentifier(String symbol) {
        JavaScriptIdentifier identifier = (JavaScriptIdentifier)this.identifiers.get(symbol);
        if (identifier == null) {
            identifier = new JavaScriptIdentifier(symbol, this);
            this.identifiers.put(symbol, identifier);
        }
        return identifier;
    }

    JavaScriptIdentifier getIdentifier(String symbol) {
        return (JavaScriptIdentifier)this.identifiers.get(symbol);
    }

    void addHint(String variableName, String variableType) {
        this.hints.put(variableName, variableType);
    }

    void preventMunging() {
        if (this.parentScope != null) {
            this.markedForMunging = false;
        }
    }

    private ArrayList getUsedSymbols() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration elements = this.identifiers.elements();
        while (elements.hasMoreElements()) {
            JavaScriptIdentifier identifier = (JavaScriptIdentifier)elements.nextElement();
            String mungedValue = identifier.getMungedValue();
            if (mungedValue == null) {
                mungedValue = identifier.getValue();
            }
            result.add(mungedValue);
        }
        return result;
    }

    private ArrayList getAllUsedSymbols() {
        ArrayList result = new ArrayList();
        ScriptOrFnScope scope = this;
        while (scope != null) {
            result.addAll(scope.getUsedSymbols());
            scope = scope.parentScope;
        }
        return result;
    }

    void munge() {
        if (!this.markedForMunging) {
            return;
        }
        int pickFromSet = 1;
        if (this.parentScope != null) {
            ArrayList freeSymbols = new ArrayList();
            freeSymbols.addAll(JavaScriptCompressor.ones);
            freeSymbols.removeAll(this.getAllUsedSymbols());
            if (freeSymbols.size() == 0) {
                pickFromSet = 2;
                freeSymbols.addAll(JavaScriptCompressor.twos);
                freeSymbols.removeAll(this.getAllUsedSymbols());
            }
            if (freeSymbols.size() == 0) {
                pickFromSet = 3;
                freeSymbols.addAll(JavaScriptCompressor.threes);
                freeSymbols.removeAll(this.getAllUsedSymbols());
            }
            if (freeSymbols.size() == 0) {
                throw new IllegalStateException("The YUI Compressor ran out of symbols. Aborting...");
            }
            Enumeration elements = this.identifiers.elements();
            while (elements.hasMoreElements()) {
                JavaScriptIdentifier identifier;
                if (freeSymbols.size() == 0) {
                    if (++pickFromSet == 2) {
                        freeSymbols.addAll(JavaScriptCompressor.twos);
                    } else if (pickFromSet == 3) {
                        freeSymbols.addAll(JavaScriptCompressor.threes);
                    } else {
                        throw new IllegalStateException("The YUI Compressor ran out of symbols. Aborting...");
                    }
                    freeSymbols.removeAll(this.getAllUsedSymbols());
                }
                String mungedValue = (identifier = (JavaScriptIdentifier)elements.nextElement()).isMarkedForMunging() ? (String)freeSymbols.remove(0) : identifier.getValue();
                identifier.setMungedValue(mungedValue);
            }
        }
        for (int i = 0; i < this.subScopes.size(); ++i) {
            ScriptOrFnScope scope = (ScriptOrFnScope)this.subScopes.get(i);
            scope.munge();
        }
    }
}

