# Testing and rule generation

## Rule generation

Rules for zones with DST are generated by calling

    :::bash
    python dst.py generate
    
At which time the `jstz.rules.js` file will be updated.

## Build with new rules:

use gulp to combine jstz.main.js and jstz.rules.js into dist/jstz.js and dist/jstz.min.js.

## Testing

Test by calling:

    :::bash
    python dst.py test 

which will report all failed time zone detections or optionally:
    
    :::bash
    python dst.py test include-success
    
which will report all successful timezone detections as well as failed ones.

To test an individual time zone and not all at once call:

    :::bash
    node test.js
    
which will simply give you the detected result for your system's set time zone. To test a 
specific time zone you can either change your system settings OR provide the timezone you  
want to test as an optional parameter to the script, such as:

    :::bash
    node test.js Asia/Beirut    