#if   !defined(__HELPREQUEST_HPP)
#define  __HELPREQUEST_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   


#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__REQUEST_HPP)
#include <corelinux/Request.hpp>
#endif

/// Create some domain types

DECLARE_TYPE( CORELINUX( Int ), HelpTopic );

const HelpTopic   UNKNOWN_HELP(-1);
const HelpTopic   REQUEST_HELP(1);
const HelpTopic   HANDLER_HELP(2);


DECLARE_CLASS( HelpRequest );

/**
Generic Request type uses identifiers instead of
derivations.
*/

class HelpRequest : public CORELINUX( Request )
{

public:

   //
   // Constructors and destructor
   //

               /// Default constructor

               HelpRequest( HelpTopicCref );

               /// Copy constructor

               HelpRequest( HelpRequestCref );

               /// Virtual Destructor

   virtual     ~HelpRequest( void );


   //
   // Operator overloads
   //

            /// Assignment operator, copies topic

            HelpRequestRef   operator=( HelpRequestCref );

            /// Equality operator compares topics

            bool  operator==( HelpRequestCref ) const;

            /// Equality operator compares topics

            bool  operator==( HelpTopicCref ) const;

   //
   // Accessors
   //

            /// True if the request was handled

   inline   bool  wasHandled( void ) const
            {
               return theHandledFlag;
            }

            /// Coercion operator for type

   inline   operator HelpTopicCref( void ) const
            {
               return theRequestType;
            }

   //
   // Mutators
   //

            /// Set the request as handled

            void  setHandled( void );
            

protected:

               /// Bad, need topic!

               HelpRequest( void ) 
                  throw ( CORELINUX(Assertion) );

private:
            /// Determines if request was handled

            bool        theHandledFlag;

            /// Describes the request type

            HelpTopic   theRequestType;

};

#endif // if !defined(__HELPREQUEST_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/04/27 14:32:21 $
   $Locker:  $
*/

