/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#include <Common.hpp>

#if   !defined(__EIGHTCYLINDERENGINE_HPP)
#include <EightCylinderEngine.hpp>
#endif 

using namespace corelinux;

// Fixed cylinder count for this type

Cylinders   EightCylinderEngine::theCylinders(8);

//
// Default constructor
//

EightCylinderEngine::EightCylinderEngine( void ) 
   :
   Engine()
{
   ;  // do nothing
}

//
// Copy constructor
//

EightCylinderEngine::EightCylinderEngine( EightCylinderEngineCref aRef ) 
   :
   Engine(aRef)
{
   ;  // do nothing
}

//
// Destructor
//

EightCylinderEngine::~EightCylinderEngine( void )
{
   ;  // do nothing,
}

//
// Assignment operator
//

EightCylinderEngineRef   EightCylinderEngine::operator=( EightCylinderEngineCref aRef ) 
{
   return (*this);
}

//
// Equality operator,
//
         
bool     EightCylinderEngine::operator==( EightCylinderEngineCref aRef ) const
{
   return (this == &aRef);
}

//
// Cylinder count fetch
//

CylindersCref   EightCylinderEngine::getCylinders( void ) const
{
   return theCylinders;
}

//
// Clone method implementation
//

EnginePtr EightCylinderEngine::clone( void ) const
{
   return new EightCylinderEngine;
}
/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/02/11 03:22:19 $
   $Locker:  $
*/



