# - Find libp11
# Find the native LIBP11 includes and library
#
#  LIBP11_INCLUDE_DIR - where to find libp11.h, etc.
#  LIBP11_LIBRARIES   - List of libraries when using libp11.
#  LIBP11_FOUND       - True if libp11 found.


IF (LIBP11_INCLUDE_DIR)
  # Already in cache, be silent
  SET(LIBP11_FIND_QUIETLY TRUE)
ENDIF (LIBP11_INCLUDE_DIR)

FIND_PATH(LIBP11_INCLUDE_DIR libp11.h)

SET(LIBP11_NAMES p11 libp11)
FIND_LIBRARY(LIBP11_LIBRARY NAMES ${LIBP11_NAMES} )

# handle the QUIETLY and REQUIRED arguments and set LIBP11_FOUND to TRUE if 
# all listed variables are TRUE
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(LibP11 DEFAULT_MSG LIBP11_LIBRARY LIBP11_INCLUDE_DIR)

IF(LIBP11_FOUND)
  SET( LIBP11_LIBRARIES ${LIBP11_LIBRARY} )
ELSE(LIBP11_FOUND)
  SET( LIBP11_LIBRARIES )
ENDIF(LIBP11_FOUND)

MARK_AS_ADVANCED( LIBP11_LIBRARY LIBP11_INCLUDE_DIR )
