with Ada.Text_IO;
with GNATCOLL.Projects;  use GNATCOLL.Projects;
with GNATCOLL.Traces;    use GNATCOLL.Traces;
with GNATCOLL.VFS;       use GNATCOLL.VFS;

procedure Gnatprove is

   Tree      : Project_Tree;

--  Start processing for Gnatprove

   procedure Check_loading (Msg : String);

   Fully_Loaded : Boolean := True;

   procedure Check_Loading (Msg : String) is
   begin
      if Msg /= "" then
--           Ada.Text_IO.Put_Line (Msg);
         Fully_Loaded := False;
      end if;
   end Check_Loading;

begin
--     Parse_Config_File ("gnatdebug");
   Tree.Load
     (GNATCOLL.VFS.Create ("test.gpr"),
      Errors => Check_Loading'Unrestricted_Access);
   if Fully_Loaded then
      Ada.Text_IO.Put_Line ("impossible runtime found");
   end if;
end Gnatprove;
