#!/bin/sh

set -e

rm -f $3
VERSION=$2
SOURCE=$(dpkg-parsechangelog | sed -ne 's,Source: \(.*\),\1,p')

SVNROOT=http://svn.code.sf.net/p/itext/code/tags/iText_$(echo $VERSION | sed -e s/\\./_/g)/itext

DIR=itext
TAR=../${SOURCE}_${VERSION}.orig.tar.xz

svn export $SVNROOT $DIR
find $DIR/src/test -name "*.pdf" -exec rm \{\} \;
tar -cvJf $TAR $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi
