package org.jboss.cache.jmx;

import javax.management.Notification;
import javax.management.NotificationEmitter;

public interface CacheNotificationBroadcaster extends NotificationEmitter
{
   // Notification Types
   String
         NOTIF_CACHE_STARTED = "org.jboss.cache.CacheStarted",
         NOTIF_CACHE_STOPPED = "org.jboss.cache.CacheStopped",
         NOTIF_NODE_CREATED = "org.jboss.cache.NodeCreated",
         NOTIF_NODE_MODIFIED = "org.jboss.cache.NodeModified",
         NOTIF_NODE_REMOVED = "org.jboss.cache.NodeRemoved",
         NOTIF_NODE_MOVED = "org.jboss.cache.NodeMoved",
         NOTIF_NODE_VISITED = "org.jboss.cache.NodeVisited",
         NOTIF_NODE_EVICTED = "org.jboss.cache.NodeEvicted",
         NOTIF_NODE_LOADED = "org.jboss.cache.NodeLoaded",
         NOTIF_NODE_ACTIVATED = "org.jboss.cache.NodeActivated",
         NOTIF_NODE_PASSIVATED = "org.jboss.cache.NodePassivated",
         NOTIF_VIEW_CHANGED = "org.jboss.cache.ViewChanged";

   /**
    * Sends a notification to any interested NotificationListener.
    *
    * @param notification the notification to send
    */
   void sendNotification(Notification notification);

   /**
    * Gets the sequence number for the next notification.
    */
   long getNextNotificationSequenceNumber();

}
