package org.jboss.cache.loader.jdbm;

import org.jboss.cache.config.CacheLoaderConfig.IndividualCacheLoaderConfig;
import org.jboss.cache.util.Util;

import java.util.Properties;

public class JdbmCacheLoaderConfig extends IndividualCacheLoaderConfig
{
   private static final long serialVersionUID = 4626734068542420865L;

   private String location;

   public JdbmCacheLoaderConfig()
   {
      setClassName(JdbmCacheLoader.class.getName());
   }

   /**
    * For use by {@link JdbmCacheLoader}.
    *
    * @param base generic config object created by XML parsing.
    */
   JdbmCacheLoaderConfig(IndividualCacheLoaderConfig base)
   {
      setClassName(JdbmCacheLoader.class.getName());
      populateFromBaseConfig(base);
   }

   public String getLocation()
   {
      return location;
   }

   public void setLocation(String location)
   {
      testImmutability("location");
      this.location = location;
   }

   @Override
   public void setProperties(Properties props)
   {
      super.setProperties(props);
      setLocation(props != null ? props.getProperty("location") : null);
   }

   @Override
   public boolean equals(Object obj)
   {
      if (obj instanceof JdbmCacheLoaderConfig && equalsExcludingProperties(obj))
      {
         return Util.safeEquals(location, ((JdbmCacheLoaderConfig) obj).location);
      }
      return false;
   }

   @Override
   public int hashCode()
   {
      return 31 * hashCodeExcludingProperties() + (location == null ? 0 : location.hashCode());
   }

   @Override
   public JdbmCacheLoaderConfig clone() throws CloneNotSupportedException
   {
      return (JdbmCacheLoaderConfig) super.clone();
   }

}