#!/bin/sh

set -e

version=`dpkg-parsechangelog | grep '^Version:' | cut -f 2 -d ' ' | sed 's/-[^-]*$//'`
echo "version ${version}"
package=`dpkg-parsechangelog | sed -n 's/^Source: //p'`
tarball="${package}_${version}.orig.tar.gz"
dir="${package}-${version}.orig"
repo="http://svn.codehaus.org/coconut/forkjoin/trunk/jsr166y/"
revision=`echo $version | sed -e 's/^0\.1\.//' -e 's/$/T1800/'`

LC_ALL=C TZ=UTC svn export --revision {$revision} "${repo}" "${dir}"
GZIP=--best tar --numeric --group 0 --owner 0 -c -v -z -f "${tarball}" "${dir}"

rm -rf "${dir}"
