/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.converters;

import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class SAXConverter {
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;
    private LocatorImpl locator;

    public SAXConverter(ContentHandler contentHandler) {
        this.setContentHandler(contentHandler);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler == null) {
            throw new NullPointerException("ContentHandler must be non-null.");
        }
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void convert(Document document) throws SAXException {
        this.locator = new LocatorImpl();
        this.locator.setSystemId(document.getBaseURI());
        this.contentHandler.setDocumentLocator(this.locator);
        this.contentHandler.startDocument();
        for (int i = 0; i < document.getChildCount(); ++i) {
            this.process(document.getChild(i));
        }
        this.contentHandler.endDocument();
    }

    private void process(Node node) throws SAXException {
        if (node instanceof Element) {
            this.convertElement((Element)node);
        } else if (node instanceof Text) {
            String string = node.getValue();
            this.contentHandler.characters(string.toCharArray(), 0, string.length());
        } else if (node instanceof ProcessingInstruction) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
            this.contentHandler.processingInstruction(processingInstruction.getTarget(), processingInstruction.getValue());
        } else if (node instanceof Comment && this.lexicalHandler != null) {
            String string = node.getValue();
            this.lexicalHandler.comment(string.toCharArray(), 0, string.length());
        } else if (node instanceof DocType && this.lexicalHandler != null) {
            DocType docType = (DocType)node;
            this.lexicalHandler.startDTD(docType.getRootElementName(), docType.getPublicID(), docType.getSystemID());
            this.lexicalHandler.endDTD();
        }
    }

    private void convertNamespace(Element element, String string) throws SAXException {
        String string2 = element.getNamespaceURI(string);
        ParentNode parentNode = element.getParent();
        Element element2 = null;
        if (parentNode instanceof Element) {
            element2 = (Element)parentNode;
        }
        if (element2 != null && string2.equals(element2.getNamespaceURI(string))) {
            return;
        }
        if (element2 == null && "".equals(string2)) {
            return;
        }
        this.contentHandler.startPrefixMapping(string, element.getNamespaceURI(string));
    }

    private void convertElement(Element element) throws SAXException {
        Object object;
        Object object2;
        int n;
        Object object3;
        this.locator.setSystemId(element.getBaseURI());
        ParentNode parentNode = element.getParent();
        Element element2 = null;
        if (parentNode instanceof Element) {
            element2 = (Element)parentNode;
        }
        for (int i = 0; i < element.getNamespaceDeclarationCount(); ++i) {
            String string = element.getNamespacePrefix(i);
            this.convertNamespace(element, string);
        }
        if (element2 != null) {
            object3 = element.getNamespacePrefix();
            if (!element.getNamespaceURI((String)object3).equals(element2.getNamespaceURI((String)object3))) {
                this.contentHandler.startPrefixMapping((String)object3, element.getNamespaceURI((String)object3));
            }
            for (n = 0; n < element.getAttributeCount(); ++n) {
                object2 = element.getAttribute(n);
                object = ((Attribute)object2).getNamespacePrefix();
                if (element.getNamespaceURI((String)object).equals(element2.getNamespaceURI((String)object)) || element.getNamespacePrefix().equals(object) || "xml".equals(object)) continue;
                this.contentHandler.startPrefixMapping((String)object, element.getNamespaceURI((String)object));
            }
        } else {
            object3 = element.getNamespacePrefix();
            if (!((String)object3).equals("") && !"xml".equals(object3)) {
                this.contentHandler.startPrefixMapping((String)object3, element.getNamespaceURI());
            }
            for (n = 0; n < element.getAttributeCount(); ++n) {
                object2 = element.getAttribute(n);
                object = ((Attribute)object2).getNamespacePrefix();
                if ("xml".equals(object) || ((String)object).equals("") || ((String)object).equals(element.getNamespacePrefix())) continue;
                this.contentHandler.startPrefixMapping((String)object, ((Attribute)object2).getNamespaceURI());
            }
        }
        object3 = new AttributesImpl();
        for (n = 0; n < element.getAttributeCount(); ++n) {
            object2 = element.getAttribute(n);
            if ("base".equals(((Attribute)object2).getLocalName()) && "http://www.w3.org/XML/1998/namespace".equals(((Attribute)object2).getNamespaceURI())) continue;
            ((AttributesImpl)object3).addAttribute(((Attribute)object2).getNamespaceURI(), ((Attribute)object2).getLocalName(), ((Attribute)object2).getQualifiedName(), SAXConverter.getSAXType((Attribute)object2), ((Attribute)object2).getValue());
        }
        this.contentHandler.startElement(element.getNamespaceURI(), element.getLocalName(), element.getQualifiedName(), (Attributes)object3);
        for (n = 0; n < element.getChildCount(); ++n) {
            this.process(element.getChild(n));
        }
        this.contentHandler.endElement(element.getNamespaceURI(), element.getLocalName(), element.getQualifiedName());
        for (n = 0; n < element.getNamespaceDeclarationCount(); ++n) {
            object2 = element.getNamespacePrefix(n);
            if (element2 == null && "".equals(object = element.getNamespaceURI((String)object2))) continue;
            this.contentHandler.endPrefixMapping((String)object2);
        }
        if (element2 != null) {
            String string = element.getNamespacePrefix();
            if (!element.getNamespaceURI(string).equals(element2.getNamespaceURI(string))) {
                this.contentHandler.endPrefixMapping(string);
            }
            for (int i = 0; i < element.getAttributeCount(); ++i) {
                object = element.getAttribute(i);
                String string2 = ((Attribute)object).getNamespacePrefix();
                if (element.getNamespaceURI(string2).equals(element2.getNamespaceURI(string2)) || element.getNamespacePrefix().equals(string2) || "xml".equals(string2)) continue;
                this.contentHandler.endPrefixMapping(string2);
            }
        } else {
            String string = element.getNamespacePrefix();
            if (!string.equals("") && !"xml".equals(string)) {
                this.contentHandler.endPrefixMapping(string);
            }
            for (int i = 0; i < element.getAttributeCount(); ++i) {
                object = element.getAttribute(i);
                String string3 = ((Attribute)object).getNamespacePrefix();
                if (string3.equals("") || string3.equals(element.getNamespacePrefix()) || "xml".equals(string3)) continue;
                this.contentHandler.endPrefixMapping(string3);
            }
        }
    }

    private static String getSAXType(Attribute attribute) {
        Attribute.Type type = attribute.getType();
        if (type.equals(Attribute.Type.UNDECLARED)) {
            return "CDATA";
        }
        if (type.equals(Attribute.Type.CDATA)) {
            return "CDATA";
        }
        if (type.equals(Attribute.Type.ID)) {
            return "ID";
        }
        if (type.equals(Attribute.Type.IDREF)) {
            return "IDREF";
        }
        if (type.equals(Attribute.Type.IDREFS)) {
            return "IDREFS";
        }
        if (type.equals(Attribute.Type.NMTOKEN)) {
            return "NMTOKEN";
        }
        if (type.equals(Attribute.Type.NMTOKENS)) {
            return "NMTOKENS";
        }
        if (type.equals(Attribute.Type.ENTITY)) {
            return "ENTITY";
        }
        if (type.equals(Attribute.Type.ENTITIES)) {
            return "ENTITIES";
        }
        if (type.equals(Attribute.Type.NOTATION)) {
            return "NOTATION";
        }
        return "NMTOKEN";
    }

    public void convert(Nodes nodes) throws SAXException {
        if (nodes.size() == 1 && nodes.get(0) instanceof Document) {
            this.convert((Document)nodes.get(0));
        } else {
            this.locator = new LocatorImpl();
            this.contentHandler.setDocumentLocator(this.locator);
            this.contentHandler.startDocument();
            for (int i = 0; i < nodes.size(); ++i) {
                this.process(nodes.get(i));
            }
            this.contentHandler.endDocument();
        }
    }
}

