/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.annotations.UserAnnotationTag;
import org.netbeans.modules.php.project.annotations.UserAnnotations;
import org.netbeans.modules.php.project.ui.PhpAnnotationsPanel;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.HelpCtx;

// implemented a bit differently than other Customizer* panels; reason:
// storage for annotations already use Preferences (as used by IDE Options)
// and we definitely want to reuse it, of course
class CustomizerAnnotations extends JPanel implements ChangeListener, HelpCtx.Provider {

    private final PhpAnnotationsPanel panel = PhpAnnotationsPanel.forProject();
    private final ProjectCustomizer.Category category;
    private final UserAnnotations userAnnotations;
    // @GuarderBy("this")
    private final List<UserAnnotationTag> annotations = new ArrayList<>();


    CustomizerAnnotations(ProjectCustomizer.Category category, PhpProject project) {
        assert EventQueue.isDispatchThread();
        assert category != null;
        assert project != null;

        this.category = category;
        userAnnotations = UserAnnotations.forProject(project);
        annotations.addAll(userAnnotations.getAnnotations());
        initComponents();
        init();
    }

    private synchronized void init() {
        assert EventQueue.isDispatchThread();
        assert Thread.holdsLock(this);
        // ui
        panel.setAnnotations(annotations);
        add(panel, BorderLayout.CENTER);
        // listeners
        panel.addChangeListener(this);
        category.setStoreListener(e -> {
            saveData();
        });
    }

    synchronized void saveData() {
        assert !EventQueue.isDispatchThread();
        assert Thread.holdsLock(this);
        userAnnotations.setAnnotations(annotations);
    }

    @Override
    public synchronized void stateChanged(ChangeEvent e) {
        assert EventQueue.isDispatchThread();
        assert Thread.holdsLock(this);
        annotations.clear();
        annotations.addAll(panel.getAnnotations());
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.project.ui.customizer.CustomizerAnnotations"); // NOI18N
    }


    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setLayout(new BorderLayout());
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
