/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.java.hints.errors;

import java.util.prefs.Preferences;

/**
 *
 * @author sdedic
 */
public class ImportClassCustomizer extends javax.swing.JPanel {
    private Preferences prefs;
    /**
     * Creates new form ImportClassCustomizer
     */
    public ImportClassCustomizer(Preferences prefs) {
        initComponents();
        this.prefs = prefs;
        
        organizeImports.setSelected(ErrorFixesFakeHint.isOrganizeAfterImportClass(prefs));
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        organizeImports = new javax.swing.JCheckBox();

        org.openide.awt.Mnemonics.setLocalizedText(organizeImports, org.openide.util.NbBundle.getMessage(ImportClassCustomizer.class, "ImportClassCustomizer.organizeImports.text")); // NOI18N
        organizeImports.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                organizeImportsActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(organizeImports)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(organizeImports)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void organizeImportsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_organizeImportsActionPerformed
        ErrorFixesFakeHint.setOrganizeAfterImportClass(prefs, organizeImports.isSelected());
    }//GEN-LAST:event_organizeImportsActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox organizeImports;
    // End of variables declaration//GEN-END:variables
}
