/* offset.cc
 */
#include "osl/offset.h"
#include "osl/boardTable.h"
#include <iostream>

#define OFFSET_INDEX(dx,dy) ((dx*BOARD_HEIGHT + dy) - OFFSET_MIN)

osl::Offset::Offset(Player player, Direction direction)
{
  *this = Board_Table.getOffset(player, direction);
}

/** 
 * Offsetから一般に dxは求まらないので,
 * ここでの入力は12近傍のみとする
 */
int osl::Offset::dx() const
{
  switch (index())
  {
  case OFFSET_INDEX(-1,-2): return -1;
  case OFFSET_INDEX(1,-2): return 1;
  case OFFSET_INDEX(-1,-1): return -1;
  case OFFSET_INDEX(0,-1): return 0;
  case OFFSET_INDEX(1,-1): return 1;
  case OFFSET_INDEX(-1,0): return -1;
  case OFFSET_INDEX(1,0): return 1;
  case OFFSET_INDEX(-1,1): return -1;
  case OFFSET_INDEX(0,1): return 0;
  case OFFSET_INDEX(1,1): return 1;
  case OFFSET_INDEX(-1,2): return -1;
  case OFFSET_INDEX(1,2): return 1;
  default: 
    std::cerr << index() << " " << ZERO().index() << "\n";
    assert(0);
  }
  return 0;
}

/** 
 * Offsetから一般に dyは求まらないので,
 * ここでの入力は12近傍のみとする
 */
int osl::Offset::dy() const
{
  switch (index())
  {
  case OFFSET_INDEX(-1,-2): return -2;
  case OFFSET_INDEX(1,-2): return -2;
  case OFFSET_INDEX(-1,-1): return -1;
  case OFFSET_INDEX(0,-1): return -1;
  case OFFSET_INDEX(1,-1): return -1;
  case OFFSET_INDEX(-1,0): return 0;
  case OFFSET_INDEX(1,0): return 0;
  case OFFSET_INDEX(-1,1): return 1;
  case OFFSET_INDEX(0,1): return 1;
  case OFFSET_INDEX(1,1): return 1;
  case OFFSET_INDEX(-1,2): return 2;
  case OFFSET_INDEX(1,2): return 2;
  default: assert(0);
  }
  return 0;
}

#ifndef MINIMAL
std::ostream& osl::operator<<(std::ostream& os, Offset offset)
{
  return os << "offset(" << offset.intValue() << ')';
}
#endif
/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
