/************************************************************************/
/*                                                                      */
/*        Copyright 2010-2011 by Ullrich Koethe and Janis Fehr          */
/*                                                                      */
/*    This file is part of the VIGRA computer vision library.           */
/*    The VIGRA Website is                                              */
/*        http://hci.iwr.uni-heidelberg.de/vigra/                       */
/*    Please direct questions, bug reports, and contributions to        */
/*        ullrich.koethe@iwr.uni-heidelberg.de    or                    */
/*        vigra@informatik.uni-hamburg.de                               */
/*                                                                      */
/*    Permission is hereby granted, free of charge, to any person       */
/*    obtaining a copy of this software and associated documentation    */
/*    files (the "Software"), to deal in the Software without           */
/*    restriction, including without limitation the rights to use,      */
/*    copy, modify, merge, publish, distribute, sublicense, and/or      */
/*    sell copies of the Software, and to permit persons to whom the    */
/*    Software is furnished to do so, subject to the following          */
/*    conditions:                                                       */
/*                                                                      */
/*    The above copyright notice and this permission notice shall be    */
/*    included in all copies or substantial portions of the             */
/*    Software.                                                         */
/*                                                                      */
/*    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND    */
/*    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES   */
/*    OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND          */
/*    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT       */
/*    HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,      */
/*    WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING      */
/*    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR     */
/*    OTHER DEALINGS IN THE SOFTWARE.                                   */
/*                                                                      */
/************************************************************************/

#ifndef VIGRA_WIGNER_MATRIX_REFERENCE_HXX
#define VIGRA_WIGNER_MATRIX_REFERENCE_HXX

static float wignerRef1[] = { 
     0.5f, 0.7071f, 0.5f, 
    -0.7071f, 0.0f, 0.7071f, 
     0.5f, -0.7071f, 0.5f };

static float wignerRef2[] = {  
    0.25f, 0.499995f, 0.612365f, 0.499995f, 0.25f, 
    -0.499995f, -0.49999f, 0.0f, 0.49999f, 0.499995f, 
    0.612365f, 0.0f, -0.499987f, 0.0f, 0.612365f, 
    -0.499995f, 0.49999f, 0.0f, -0.49999f, 0.499995f, 
    0.25f, -0.499995f, 0.612365f, -0.499995f, 0.25f };

static float wignerRef3[] = {  
    0.125f, 0.306183f, 0.484115f, 0.559007f, 0.484115f, 0.306183f, 0.125f, 
    -0.306183f, -0.49999f, -0.395275f, 0.0f, 0.395275f, 0.49999f, 0.306183f, 
    0.484115f, 0.395275f, -0.124996f, -0.432999f, -0.124996f, 0.395275f, 0.484115f, 
    -0.559007f, 0.0f, 0.432999f, 0.0f, -0.432999f, 0.0f, 0.559007f, 
    0.484115f, -0.395275f, -0.124996f, 0.432999f, -0.124996f, -0.395275f, 0.484115f, 
    -0.306183f, 0.49999f, -0.395275f, 0.0f, 0.395275f, -0.49999f, 0.306183f, 
    0.125f, -0.306183f, 0.484115f, -0.559007f, 0.484115f, -0.306183f, 0.125f };

static float wignerRef4[] = {  
    0.0625f, 0.176775f, 0.330713f, 0.467698f, 0.522901f, 0.467698f, 0.330713f, 0.176775f, 0.0625f, 
    -0.176775f, -0.374993f, -0.467695f, -0.330709f, -7.45058e-09f, 0.330709f, 0.467695f, 0.374993f, 0.176775f, 
    0.330713f, 0.467695f, 0.249992f, -0.17677f, -0.395269f, -0.17677f, 0.249992f, 0.467695f, 0.330713f, 
    -0.467698f, -0.330709f, 0.17677f, 0.374985f, 1.86265e-09f, -0.374985f, -0.17677f, 0.330709f, 0.467698f, 
    0.522901f, 0.0f, -0.395269f, 5.58794e-09f, 0.374984f, 1.11759e-08f, -0.395269f, 0.0f, 0.522901f, 
    -0.467698f, 0.330709f, 0.17677f, -0.374985f, -3.72529e-09f, 0.374985f, -0.17677f, -0.330709f, 0.467698f, 
    0.330713f, -0.467695f, 0.249992f, 0.17677f, -0.39527f, 0.17677f, 0.249992f, -0.467695f, 0.330713f, 
    -0.176775f, 0.374993f, -0.467695f, 0.330709f, -7.45058e-09f, -0.330709f, 0.467695f, -0.374993f, 0.176775f, 
    0.0625f, -0.176775f, 0.330713f, -0.467698f, 0.522901f, -0.467698f, 0.330713f, -0.176775f, 0.0625f };

static float wignerRef5[] = {  
    0.03125f, 0.0988202f, 0.209628f, 0.342319f, 0.452844f, 0.496065f, 0.452844f, 0.342319f, 0.209628f, 0.0988202f, 0.03125f, 
    -0.0988202f, -0.249995f, -0.397737f, -0.432999f, -0.286401f, 0.0f, 0.286401f, 0.432999f, 0.397737f, 0.249995f, 0.0988202f, 
    0.209628f, 0.397737f, 0.406236f, 0.153087f, -0.202514f, -0.369739f, -0.202514f, 0.153087f, 0.406236f, 0.397737f, 0.209628f, 
    -0.342319f, -0.432999f, -0.153087f, 0.249989f, 0.330703f, 1.86265e-09f, -0.330703f, -0.249989f, 0.153087f, 0.432999f, 0.342319f, 
    0.452844f, 0.286401f, -0.202514f, -0.330703f, 0.0624968f, 0.342309f, 0.0624968f, -0.330703f, -0.202514f, 0.286401f, 0.452844f, 
    -0.496065f, 0.0f, 0.369739f, -1.86265e-09f, -0.342309f, 0.0f, 0.342309f, -7.45058e-09f, -0.369739f, 0.0f, 0.496065f, 
    0.452844f, -0.286401f, -0.202514f, 0.330703f, 0.0624968f, -0.342309f, 0.0624968f, 0.330703f, -0.202514f, -0.286401f, 0.452844f, 
    -0.342319f, 0.432999f, -0.153087f, -0.249989f, 0.330703f, 0.0f, -0.330703f, 0.249989f, 0.153087f, -0.432999f, 0.342319f, 
    0.209628f, -0.397737f, 0.406236f, -0.153087f, -0.202514f, 0.369739f, -0.202514f, -0.153087f, 0.406236f, -0.397737f, 0.209628f, 
    -0.0988202f, 0.249995f, -0.397737f, 0.432999f, -0.286401f, 7.45058e-09f, 0.286401f, -0.432999f, 0.397737f, -0.249995f, 0.0988202f, 
    0.03125f, -0.0988202f, 0.209628f, -0.342319f, 0.452844f, -0.496065f, 0.452844f, -0.342319f, 0.209628f, -0.0988202f, 0.03125f };

static float wignerRef6[] = {  
    0.015625f, 0.0541261f, 0.126936f, 0.231751f, 0.347625f, 0.439713f, 0.474944f, 0.439713f, 0.347625f, 0.231751f, 0.126936f, 0.0541261f, 0.015625f, 
    -0.0541261f, -0.156247f, -0.293143f, -0.4014f, -0.401398f, -0.253866f, 0.0f, 0.253866f, 0.401398f, 0.4014f, 0.293143f, 0.156247f, 0.0541261f, 
    0.126936f, 0.293143f, 0.406236f, 0.342313f, 0.0855778f, -0.216496f, -0.350763f, -0.216496f, 0.0855778f, 0.342313f, 0.406236f, 0.293143f, 0.126936f, 
    -0.231751f, -0.4014f, -0.342313f, -0.0312486f, 0.281236f, 0.296447f, 7.45058e-09f, -0.296447f, -0.281235f, 0.0312485f, 0.342313f, 0.4014f, 0.231751f, 
    0.347625f, 0.401398f, 0.0855778f, -0.281236f, -0.26561f, 0.0988154f, 0.320198f, 0.0988154f, -0.26561f, -0.281235f, 0.0855778f, 0.401398f, 0.347625f, 
    -0.439713f, -0.253866f, 0.216496f, 0.296447f, -0.0988154f, -0.312481f, 9.31323e-09f, 0.312481f, 0.0988154f, -0.296447f, -0.216496f, 0.253866f, 0.439713f, 
    0.474944f, -7.45058e-09f, -0.350763f, 0.0f, 0.320198f, 1.86265e-09f, -0.31248f, 3.72529e-09f, 0.320198f, -3.72529e-09f, -0.350763f, 0.0f, 0.474944f, 
    -0.439713f, 0.253866f, 0.216496f, -0.296447f, -0.0988154f, 0.312481f, 1.11759e-08f, -0.312481f, 0.0988154f, 0.296447f, -0.216496f, -0.253866f, 0.439713f, 
    0.347625f, -0.401398f, 0.0855778f, 0.281235f, -0.26561f, -0.0988154f, 0.320198f, -0.0988154f, -0.26561f, 0.281235f, 0.0855777f, -0.401398f, 0.347625f, 
    -0.231751f, 0.4014f, -0.342313f, 0.0312485f, 0.281236f, -0.296447f, 3.72529e-09f, 0.296447f, -0.281235f, -0.0312485f, 0.342313f, -0.4014f, 0.231751f, 
    0.126936f, -0.293143f, 0.406236f, -0.342313f, 0.0855778f, 0.216496f, -0.350763f, 0.216496f, 0.0855777f, -0.342313f, 0.406236f, -0.293143f, 0.126936f, 
    -0.0541261f, 0.156247f, -0.293143f, 0.4014f, -0.401398f, 0.253866f, -3.72529e-09f, -0.253866f, 0.401398f, -0.4014f, 0.293143f, -0.156247f, 0.0541261f, 
    0.015625f, -0.0541261f, 0.126936f, -0.231751f, 0.347625f, -0.439713f, 0.474944f, -0.439713f, 0.347625f, -0.231751f, 0.126936f, -0.0541261f, 0.015625f };

static float wignerRef7[] = {  
    0.0078125f, 0.0292314f, 0.0745252f, 0.149049f, 0.247169f, 0.349549f, 0.428107f, 0.457665f, 0.428107f, 0.349549f, 0.247169f, 0.149049f, 0.0745252f, 0.0292314f, 0.0078125f, 
    -0.0292314f, -0.0937482f, -0.199175f, -0.318678f, -0.396349f, -0.37368f, -0.228831f, 0.0f, 0.228831f, 0.37368f, 0.396349f, 0.318678f, 0.199175f, 0.0937482f, 0.0292314f, 
    0.0745252f, 0.199175f, 0.335926f, 0.390609f, 0.285009f, 0.036642f, -0.224385f, -0.335829f, -0.224385f, 0.036642f, 0.285009f, 0.390609f, 0.335926f, 0.199175f, 0.0745252f, 
    -0.149049f, -0.318678f, -0.390609f, -0.249988f, 0.0518195f, 0.293134f, 0.26926f, 1.86265e-09f, -0.26926f, -0.293134f, -0.0518195f, 0.249988f, 0.390609f, 0.318678f, 0.149049f, 
    0.247169f, 0.396349f, 0.285009f, -0.0518195f, -0.304669f, -0.209909f, 0.121777f, 0.303765f, 0.121777f, -0.209909f, -0.304669f, -0.0518194f, 0.285009f, 0.396349f, 0.247169f, 
    -0.349549f, -0.37368f, -0.036642f, 0.293134f, 0.209909f, -0.15624f, -0.28703f, 3.72529e-09f, 0.28703f, 0.15624f, -0.209909f, -0.293134f, 0.036642f, 0.37368f, 0.349549f, 
    0.428107f, 0.228831f, -0.224385f, -0.26926f, 0.121777f, 0.28703f, -0.0390597f, -0.292296f, -0.0390597f, 0.28703f, 0.121777f, -0.26926f, -0.224385f, 0.228831f, 0.428107f, 
    -0.457665f, 7.45058e-09f, 0.335829f, -9.31323e-10f, -0.303765f, -1.86265e-09f, 0.292296f, 0.0f, -0.292296f, 7.45058e-09f, 0.303765f, 0.0f, -0.335828f, -7.45058e-09f, 0.457665f, 
    0.428107f, -0.228831f, -0.224385f, 0.26926f, 0.121777f, -0.28703f, -0.0390597f, 0.292296f, -0.0390597f, -0.28703f, 0.121777f, 0.26926f, -0.224385f, -0.228831f, 0.428107f, 
    -0.349549f, 0.37368f, -0.036642f, -0.293134f, 0.209909f, 0.15624f, -0.28703f, 0.0f, 0.28703f, -0.15624f, -0.209909f, 0.293134f, 0.036642f, -0.37368f, 0.349549f, 
    0.247169f, -0.396349f, 0.285009f, 0.0518195f, -0.304669f, 0.209909f, 0.121777f, -0.303765f, 0.121777f, 0.209909f, -0.304669f, 0.0518195f, 0.285009f, -0.396349f, 0.247169f, 
    -0.149049f, 0.318678f, -0.390609f, 0.249988f, 0.0518195f, -0.293134f, 0.26926f, 0.0f, -0.26926f, 0.293134f, -0.0518195f, -0.249988f, 0.390609f, -0.318678f, 0.149049f, 
    0.0745252f, -0.199175f, 0.335926f, -0.390609f, 0.285009f, -0.036642f, -0.224385f, 0.335828f, -0.224385f, -0.036642f, 0.285009f, -0.390609f, 0.335926f, -0.199175f, 0.0745252f, 
    -0.0292314f, 0.0937482f, -0.199175f, 0.318678f, -0.396349f, 0.37368f, -0.228831f, 0.0f, 0.228831f, -0.37368f, 0.396349f, -0.318678f, 0.199175f, -0.0937482f, 0.0292314f, 
    0.0078125f, -0.0292314f, 0.0745252f, -0.149049f, 0.247169f, -0.349549f, 0.428107f, -0.457665f, 0.428107f, -0.349549f, 0.247169f, -0.149049f, 0.0745252f, -0.0292314f, 0.0078125f };

static float wignerRef8[] = {  
    0.00390625f, 0.0156249f, 0.0427901f, 0.0924364f, 0.166641f, 0.258158f, 0.349547f, 0.417788f, 0.44313f, 0.417788f, 0.349547f, 0.258158f, 0.166641f, 0.0924364f, 0.0427901f, 0.0156249f, 0.00390625f, 
    -0.0156249f, -0.0546864f, -0.128369f, -0.231089f, -0.333279f, -0.387234f, -0.349543f, -0.208892f, 0.0f, 0.208892f, 0.349543f, 0.387234f, 0.333279f, 0.231089f, 0.128369f, 0.0546864f, 0.0156249f, 
    0.0427901f, 0.128369f, 0.249991f, 0.3544f, 0.365086f, 0.235661f, -1.11759e-08f, -0.228828f, -0.323611f, -0.228828f, -2.79397e-09f, 0.235661f, 0.365086f, 0.3544f, 0.249991f, 0.128369f, 0.0427901f, 
    -0.0924364f, -0.231089f, -0.3544f, -0.351545f, -0.169001f, 0.109089f, 0.295414f, 0.24716f, -3.72529e-09f, -0.24716f, -0.295414f, -0.109089f, 0.169001f, 0.351545f, 0.3544f, 0.231089f, 0.0924364f, 
    0.166641f, 0.333279f, 0.365086f, 0.169001f, -0.140616f, -0.302557f, -0.163865f, 0.137099f, 0.290831f, 0.137099f, -0.163865f, -0.302557f, -0.140616f, 0.169001f, 0.365086f, 0.333279f, 0.166641f, 
    -0.258158f, -0.387234f, -0.235661f, 0.109089f, 0.302557f, 0.132803f, -0.190393f, -0.26549f, -1.86265e-09f, 0.26549f, 0.190393f, -0.132803f, -0.302557f, -0.109089f, 0.235661f, 0.387234f, 0.258158f, 
    0.349547f, 0.349543f, 1.30385e-08f, -0.295414f, -0.163865f, 0.190393f, 0.249981f, -0.0653589f, -0.277294f, -0.0653589f, 0.249981f, 0.190393f, -0.163865f, -0.295414f, 1.11759e-08f, 0.349543f, 0.349547f, 
    -0.417788f, -0.208892f, 0.228828f, 0.24716f, -0.137099f, -0.26549f, 0.0653589f, 0.273415f, -5.58794e-09f, -0.273415f, -0.0653589f, 0.26549f, 0.137099f, -0.24716f, -0.228828f, 0.208892f, 0.417788f, 
    0.44313f, -3.72529e-09f, -0.323611f, 9.31323e-10f, 0.290831f, 1.86265e-09f, -0.277294f, 0.0f, 0.273415f, -7.45058e-09f, -0.277294f, 3.72529e-09f, 0.290831f, 7.45058e-09f, -0.323611f, -3.72529e-09f, 0.44313f, 
    -0.417788f, 0.208892f, 0.228828f, -0.24716f, -0.137099f, 0.26549f, 0.0653589f, -0.273415f, 3.72529e-09f, 0.273415f, -0.0653589f, -0.26549f, 0.137099f, 0.24716f, -0.228828f, -0.208892f, 0.417788f, 
    0.349547f, -0.349543f, 0.0f, 0.295414f, -0.163865f, -0.190393f, 0.249981f, 0.0653589f, -0.277294f, 0.0653589f, 0.249981f, -0.190393f, -0.163865f, 0.295414f, -7.45058e-09f, -0.349543f, 0.349547f, 
    -0.258158f, 0.387234f, -0.235661f, -0.109089f, 0.302557f, -0.132803f, -0.190393f, 0.26549f, 3.72529e-09f, -0.26549f, 0.190393f, 0.132803f, -0.302557f, 0.109089f, 0.235661f, -0.387234f, 0.258158f, 
    0.166641f, -0.333279f, 0.365086f, -0.169001f, -0.140616f, 0.302557f, -0.163865f, -0.137099f, 0.290831f, -0.137099f, -0.163865f, 0.302557f, -0.140616f, -0.169001f, 0.365086f, -0.333279f, 0.166641f, 
    -0.0924364f, 0.231089f, -0.3544f, 0.351545f, -0.169001f, -0.109089f, 0.295414f, -0.24716f, 7.45058e-09f, 0.24716f, -0.295414f, 0.109089f, 0.169001f, -0.351545f, 0.3544f, -0.231089f, 0.0924364f, 
    0.0427901f, -0.128369f, 0.249991f, -0.3544f, 0.365086f, -0.235661f, 1.11759e-08f, 0.228828f, -0.323611f, 0.228828f, -1.49012e-08f, -0.235661f, 0.365086f, -0.3544f, 0.249991f, -0.128369f, 0.0427901f, 
    -0.0156249f, 0.0546864f, -0.128369f, 0.231089f, -0.333279f, 0.387234f, -0.349543f, 0.208892f, -3.72529e-09f, -0.208892f, 0.349543f, -0.387234f, 0.333279f, -0.231089f, 0.128369f, -0.0546864f, 0.0156249f, 
    0.00390625f, -0.0156249f, 0.0427901f, -0.0924364f, 0.166641f, -0.258158f, 0.349547f, -0.417788f, 0.44313f, -0.417788f, 0.349547f, -0.258158f, 0.166641f, -0.0924364f, 0.0427901f, -0.0156249f, 0.00390625f };

static float wignerRef9[] = {  
    0.00195312f, 0.00828633f, 0.0241584f, 0.055791f, 0.108038f, 0.180781f, 0.266102f, 0.348408f, 0.408544f, 0.430643f, 0.408544f, 0.348408f, 0.266102f, 0.180781f, 0.108038f, 0.055791f, 0.0241584f, 0.00828633f, 0.00195312f, 
    -0.00828633f, -0.0312494f, -0.0797178f, -0.157799f, -0.254646f, -0.340881f, -0.376321f, -0.328479f, -0.192588f, 3.72529e-09f, 0.192588f, 0.328479f, 0.376321f, 0.340881f, 0.254646f, 0.157799f, 0.0797178f, 0.0312494f, 0.00828633f, 
    0.0241584f, 0.0797178f, 0.173822f, 0.284152f, 0.358102f, 0.336146f, 0.193614f, -0.0281666f, -0.231198f, -0.313333f, -0.231198f, -0.0281666f, 0.193614f, 0.336146f, 0.358102f, 0.284152f, 0.173822f, 0.0797178f, 0.0241584f, 
    -0.055791f, -0.157799f, -0.284152f, -0.359357f, -0.30256f, -0.101255f, 0.149043f, 0.292714f, 0.228825f, -3.25963e-09f, -0.228825f, -0.292714f, -0.149043f, 0.101255f, 0.30256f, 0.359357f, 0.284152f, 0.157799f, 0.055791f, 
    0.108038f, 0.254646f, 0.358102f, 0.30256f, 0.070308f, -0.196079f, -0.288619f, -0.125963f, 0.147705f, 0.28025f, 0.147705f, -0.125963f, -0.288619f, -0.196079f, 0.0703081f, 0.30256f, 0.358102f, 0.254646f, 0.108038f, 
    -0.180781f, -0.340881f, -0.336146f, -0.101255f, 0.196079f, 0.281229f, 0.0689928f, -0.210776f, -0.247156f, -5.58794e-09f, 0.247156f, 0.210776f, -0.0689928f, -0.281229f, -0.196079f, 0.101255f, 0.336146f, 0.340881f, 0.180781f, 
    0.266102f, 0.376321f, 0.193614f, -0.149043f, -0.288619f, -0.0689928f, 0.226544f, 0.21479f, -0.0839545f, -0.265487f, -0.0839545f, 0.21479f, 0.226544f, -0.0689928f, -0.288619f, -0.149043f, 0.193614f, 0.376321f, 0.266102f, 
    -0.348408f, -0.328479f, 0.0281666f, 0.292714f, 0.125963f, -0.210776f, -0.21479f, 0.109365f, 0.256484f, -7.45058e-09f, -0.256484f, -0.109365f, 0.21479f, 0.210776f, -0.125963f, -0.292714f, -0.0281666f, 0.328479f, 0.348408f, 
    0.408544f, 0.192588f, -0.231198f, -0.228825f, 0.147705f, 0.247156f, -0.0839544f, -0.256484f, 0.0273413f, 0.259382f, 0.0273413f, -0.256484f, -0.0839544f, 0.247156f, 0.147705f, -0.228825f, -0.231198f, 0.192588f, 0.408544f, 
    -0.430643f, 3.72529e-09f, 0.313333f, -5.12227e-09f, -0.28025f, -2.79397e-09f, 0.265487f, 3.72529e-09f, -0.259382f, 0.0f, 0.259382f, -7.45058e-09f, -0.265487f, 0.0f, 0.28025f, 0.0f, -0.313333f, -7.45058e-09f, 0.430643f, 
    0.408544f, -0.192588f, -0.231198f, 0.228825f, 0.147705f, -0.247156f, -0.0839544f, 0.256484f, 0.0273413f, -0.259382f, 0.0273413f, 0.256484f, -0.0839544f, -0.247156f, 0.147705f, 0.228825f, -0.231198f, -0.192588f, 0.408544f, 
    -0.348408f, 0.328479f, 0.0281666f, -0.292714f, 0.125963f, 0.210776f, -0.21479f, -0.109365f, 0.256484f, 0.0f, -0.256484f, 0.109365f, 0.21479f, -0.210776f, -0.125963f, 0.292714f, -0.0281666f, -0.328479f, 0.348408f, 
    0.266102f, -0.376321f, 0.193614f, 0.149043f, -0.288619f, 0.0689928f, 0.226544f, -0.21479f, -0.0839544f, 0.265487f, -0.0839544f, -0.21479f, 0.226544f, 0.0689928f, -0.288619f, 0.149043f, 0.193614f, -0.376321f, 0.266102f, 
    -0.180781f, 0.340881f, -0.336146f, 0.101255f, 0.196079f, -0.281229f, 0.0689928f, 0.210776f, -0.247156f, 3.72529e-09f, 0.247156f, -0.210776f, -0.0689928f, 0.281229f, -0.196079f, -0.101255f, 0.336146f, -0.340881f, 0.180781f, 
    0.108038f, -0.254646f, 0.358102f, -0.30256f, 0.0703081f, 0.196079f, -0.288619f, 0.125963f, 0.147705f, -0.28025f, 0.147705f, 0.125963f, -0.288619f, 0.196079f, 0.070308f, -0.30256f, 0.358102f, -0.254646f, 0.108038f, 
    -0.055791f, 0.157799f, -0.284152f, 0.359357f, -0.30256f, 0.101255f, 0.149043f, -0.292714f, 0.228825f, -3.72529e-09f, -0.228825f, 0.292714f, -0.149043f, -0.101255f, 0.30256f, -0.359357f, 0.284152f, -0.157799f, 0.055791f, 
    0.0241584f, -0.0797178f, 0.173822f, -0.284152f, 0.358102f, -0.336146f, 0.193614f, 0.0281666f, -0.231198f, 0.313333f, -0.231198f, 0.0281666f, 0.193614f, -0.336146f, 0.358102f, -0.284152f, 0.173822f, -0.0797178f, 0.0241584f, 
    -0.00828633f, 0.0312494f, -0.0797178f, 0.157799f, -0.254646f, 0.340881f, -0.376321f, 0.328479f, -0.192588f, 3.72529e-09f, 0.192588f, -0.328479f, 0.376321f, -0.340881f, 0.254646f, -0.157799f, 0.0797178f, -0.0312494f, 0.00828633f, 
    0.00195312f, -0.00828633f, 0.0241584f, -0.055791f, 0.108038f, -0.180781f, 0.266102f, -0.348408f, 0.408544f, -0.430643f, 0.408544f, -0.348408f, 0.266102f, -0.180781f, 0.108038f, -0.055791f, 0.0241584f, -0.00828633f, 0.00195312f };

static float wignerRef10[] = {  
    0.000976562f, 0.00436728f, 0.0134607f, 0.0329717f, 0.0679724f, 0.121592f, 0.192253f, 0.271886f, 0.346587f, 0.400204f, 0.419737f, 0.400204f, 0.346587f, 0.271886f, 0.192253f, 0.121592f, 0.0679724f, 0.0329717f, 0.0134607f, 0.00436728f, 0.000976562f, 
    -0.00436728f, -0.0175778f, -0.0481581f, -0.103217f, -0.182387f, -0.271886f, -0.34391f, -0.36477f, -0.309994f, -0.178975f, 0.0f, 0.178975f, 0.309994f, 0.36477f, 0.34391f, 0.271886f, 0.182387f, 0.103217f, 0.0481581f, 0.0175778f, 0.00436728f, 
    0.0134607f, 0.0481581f, 0.11523f, 0.210494f, 0.305731f, 0.352842f, 0.30684f, 0.157795f, -0.0502873f, -0.232266f, -0.304504f, -0.232266f, -0.0502872f, 0.157795f, 0.30684f, 0.352842f, 0.305731f, 0.210494f, 0.11523f, 0.0481581f, 0.0134607f, 
    -0.0329717f, -0.103217f, -0.210494f, -0.314437f, -0.346256f, -0.252081f, -0.0455512f, 0.177152f, 0.287413f, 0.213349f, -4.19095e-09f, -0.213349f, -0.287413f, -0.177152f, 0.0455512f, 0.252081f, 0.346256f, 0.314437f, 0.210494f, 0.103217f, 0.0329717f, 
    0.0679724f, 0.182387f, 0.305731f, 0.346256f, 0.23143f, -0.00873404f, -0.22924f, -0.26951f, -0.094603f, 0.155233f, 0.271349f, 0.155233f, -0.094603f, -0.26951f, -0.22924f, -0.00873401f, 0.23143f, 0.346256f, 0.305731f, 0.182387f, 0.0679724f, 
    -0.121592f, -0.271886f, -0.352842f, -0.252081f, 0.00873402f, 0.242169f, 0.247033f, 0.0174678f, -0.222671f, -0.231406f, -1.49012e-08f, 0.231406f, 0.222671f, -0.0174678f, -0.247033f, -0.242169f, -0.008734f, 0.252081f, 0.352842f, 0.271886f, 0.121592f, 
    0.192253f, 0.34391f, 0.30684f, 0.0455512f, -0.22924f, -0.247033f, 0.00781185f, 0.243046f, 0.183078f, -0.0975691f, -0.255828f, -0.0975691f, 0.183078f, 0.243046f, 0.00781184f, -0.247033f, -0.22924f, 0.0455512f, 0.30684f, 0.34391f, 0.192253f, 
    -0.271886f, -0.36477f, -0.157795f, 0.177152f, 0.26951f, 0.0174678f, -0.243046f, -0.164047f, 0.139413f, 0.24147f, 0.0f, -0.24147f, -0.139413f, 0.164047f, 0.243046f, -0.0174678f, -0.26951f, -0.177152f, 0.157795f, 0.36477f, 0.271886f, 
    0.346587f, 0.309994f, -0.0502872f, -0.287413f, -0.094603f, 0.222671f, 0.183078f, -0.139413f, -0.232399f, 0.0473561f, 0.248337f, 0.0473561f, -0.232399f, -0.139413f, 0.183078f, 0.222671f, -0.094603f, -0.287413f, -0.0502872f, 0.309994f, 0.346587f, 
    -0.400204f, -0.178975f, 0.232266f, 0.213349f, -0.155233f, -0.231406f, 0.097569f, 0.24147f, -0.0473561f, -0.246069f, 7.45058e-09f, 0.246069f, 0.0473561f, -0.24147f, -0.0975691f, 0.231406f, 0.155233f, -0.213349f, -0.232266f, 0.178975f, 0.400204f, 
    0.419737f, 0.0f, -0.304504f, -9.31323e-10f, 0.271349f, 3.72529e-09f, -0.255828f, 3.72529e-09f, 0.248337f, -1.86265e-09f, -0.246069f, 3.72529e-09f, 0.248337f, 3.72529e-09f, -0.255828f, 3.72529e-09f, 0.271349f, 0.0f, -0.304504f, -3.72529e-09f, 0.419737f, 
    -0.400204f, 0.178975f, 0.232266f, -0.213349f, -0.155233f, 0.231406f, 0.097569f, -0.24147f, -0.0473561f, 0.246069f, 0.0f, -0.246069f, 0.0473561f, 0.24147f, -0.097569f, -0.231406f, 0.155233f, 0.213349f, -0.232266f, -0.178975f, 0.400204f, 
    0.346587f, -0.309994f, -0.0502872f, 0.287413f, -0.094603f, -0.222671f, 0.183078f, 0.139413f, -0.232399f, -0.0473561f, 0.248337f, -0.0473561f, -0.232399f, 0.139413f, 0.183078f, -0.222671f, -0.094603f, 0.287413f, -0.0502872f, -0.309994f, 0.346587f, 
    -0.271886f, 0.36477f, -0.157795f, -0.177152f, 0.26951f, -0.0174678f, -0.243046f, 0.164047f, 0.139413f, -0.24147f, 0.0f, 0.24147f, -0.139413f, -0.164047f, 0.243046f, 0.0174678f, -0.26951f, 0.177152f, 0.157795f, -0.36477f, 0.271886f, 
    0.192253f, -0.34391f, 0.30684f, -0.0455512f, -0.22924f, 0.247033f, 0.00781183f, -0.243046f, 0.183078f, 0.0975691f, -0.255828f, 0.0975691f, 0.183078f, -0.243046f, 0.00781185f, 0.247033f, -0.22924f, -0.0455512f, 0.30684f, -0.34391f, 0.192253f, 
    -0.121592f, 0.271886f, -0.352842f, 0.252081f, 0.00873402f, -0.242169f, 0.247033f, -0.0174678f, -0.222671f, 0.231406f, 0.0f, -0.231406f, 0.222671f, 0.0174678f, -0.247033f, 0.242169f, -0.00873403f, -0.252081f, 0.352842f, -0.271886f, 0.121592f, 
    0.0679724f, -0.182387f, 0.305731f, -0.346256f, 0.23143f, 0.00873402f, -0.22924f, 0.26951f, -0.094603f, -0.155233f, 0.271349f, -0.155233f, -0.094603f, 0.26951f, -0.22924f, 0.00873404f, 0.23143f, -0.346256f, 0.305731f, -0.182387f, 0.0679724f, 
    -0.0329717f, 0.103217f, -0.210494f, 0.314437f, -0.346256f, 0.252081f, -0.0455512f, -0.177152f, 0.287413f, -0.213349f, 0.0f, 0.213349f, -0.287413f, 0.177152f, 0.0455512f, -0.252081f, 0.346256f, -0.314437f, 0.210494f, -0.103217f, 0.0329717f, 
    0.0134607f, -0.0481581f, 0.11523f, -0.210494f, 0.305731f, -0.352842f, 0.30684f, -0.157795f, -0.0502872f, 0.232266f, -0.304504f, 0.232266f, -0.0502872f, -0.157795f, 0.30684f, -0.352842f, 0.305731f, -0.210494f, 0.11523f, -0.0481581f, 0.0134607f, 
    -0.00436728f, 0.0175778f, -0.0481581f, 0.103217f, -0.182387f, 0.271886f, -0.34391f, 0.36477f, -0.309994f, 0.178975f, 0.0f, -0.178975f, 0.309994f, -0.36477f, 0.34391f, -0.271886f, 0.182387f, -0.103217f, 0.0481581f, -0.0175778f, 0.00436728f, 
    0.000976562f, -0.00436728f, 0.0134607f, -0.0329717f, 0.0679724f, -0.121592f, 0.192253f, -0.271886f, 0.346587f, -0.400204f, 0.419737f, -0.400204f, 0.346587f, -0.271886f, 0.192253f, -0.121592f, 0.0679724f, -0.0329717f, 0.0134607f, -0.00436728f, 0.000976562f };

static float wignerRef11[] = {  
    0.000488281f, 0.00229022f, 0.0074211f, 0.019161f, 0.0417602f, 0.079234f, 0.13337f, 0.201636f, 0.2761f, 0.344357f, 0.392626f, 0.410085f, 0.392626f, 0.344357f, 0.2761f, 0.201636f, 0.13337f, 0.079234f, 0.0417602f, 0.019161f, 0.0074211f, 0.00229022f, 0.000488281f, 
    -0.00229022f, -0.00976544f, -0.028479f, -0.0653617f, -0.124645f, -0.202711f, -0.284343f, -0.343908f, -0.353185f, -0.293665f, -0.167415f, -3.72529e-09f, 0.167415f, 0.293665f, 0.353185f, 0.343908f, 0.284343f, 0.202711f, 0.124645f, 0.0653617f, 0.028479f, 0.00976544f, 0.00229022f, 
    0.0074211f, 0.028479f, 0.0737278f, 0.1475f, 0.239039f, 0.318f, 0.342223f, 0.278595f, 0.12716f, -0.0679698f, -0.232492f, -0.296792f, -0.232492f, -0.0679698f, 0.12716f, 0.278595f, 0.342223f, 0.318f, 0.239039f, 0.1475f, 0.0737278f, 0.028479f, 0.0074211f, 
    -0.019161f, -0.0653617f, -0.1475f, -0.249987f, -0.327749f, -0.323043f, -0.20391f, 4.19095e-09f, 0.196994f, 0.280793f, 0.200096f, 3.25963e-09f, -0.200096f, -0.280793f, -0.196994f, -9.31323e-09f, 0.20391f, 0.323043f, 0.327749f, 0.249987f, 0.1475f, 0.0653617f, 0.019161f, 
    0.0417602f, 0.124645f, 0.239039f, 0.327749f, 0.313944f, 0.162117f, -0.0701697f, -0.247534f, -0.248563f, -0.0684441f, 0.160667f, 0.263703f, 0.160667f, -0.0684441f, -0.248563f, -0.247534f, -0.0701696f, 0.162117f, 0.313944f, 0.327749f, 0.239039f, 0.124645f, 0.0417602f, 
    -0.079234f, -0.202711f, -0.318f, -0.323043f, -0.162117f, 0.0917897f, 0.261342f, 0.208738f, -0.0238188f, -0.22917f, -0.217744f, -3.72529e-09f, 0.217744f, 0.22917f, 0.0238188f, -0.208738f, -0.261342f, -0.0917897f, 0.162117f, 0.323043f, 0.318f, 0.202711f, 0.079234f, 
    0.13337f, 0.284343f, 0.342223f, 0.20391f, -0.0701696f, -0.261343f, -0.192854f, 0.0671711f, 0.247632f, 0.155055f, -0.107799f, -0.247703f, -0.107799f, 0.155055f, 0.247632f, 0.0671711f, -0.192854f, -0.261342f, -0.0701696f, 0.20391f, 0.342223f, 0.284343f, 0.13337f, 
    -0.201636f, -0.343908f, -0.278595f, -5.12227e-09f, 0.247534f, 0.208738f, -0.0671711f, -0.249976f, -0.117663f, 0.160092f, 0.228166f, 1.86265e-09f, -0.228166f, -0.160092f, 0.117663f, 0.249976f, 0.0671711f, -0.208738f, -0.247534f, 1.49012e-08f, 0.278595f, 0.343908f, 0.201636f, 
    0.2761f, 0.353185f, 0.12716f, -0.196994f, -0.248563f, 0.0238188f, 0.247632f, 0.117663f, -0.174787f, -0.208254f, 0.0624857f, 0.239302f, 0.0624857f, -0.208254f, -0.174787f, 0.117663f, 0.247632f, 0.0238188f, -0.248563f, -0.196994f, 0.12716f, 0.353185f, 0.2761f, 
    -0.344357f, -0.293665f, 0.0679697f, 0.280793f, 0.0684441f, -0.22917f, -0.155055f, 0.160092f, 0.208254f, -0.0820225f, -0.2338f, 7.45058e-09f, 0.2338f, 0.0820225f, -0.208254f, -0.160092f, 0.155055f, 0.22917f, -0.0684441f, -0.280793f, -0.0679697f, 0.293665f, 0.344357f, 
    0.392626f, 0.167415f, -0.232492f, -0.200096f, 0.160667f, 0.217744f, -0.107799f, -0.228166f, 0.0624857f, 0.2338f, -0.0205056f, -0.235591f, -0.0205056f, 0.2338f, 0.0624857f, -0.228166f, -0.107799f, 0.217744f, 0.160667f, -0.200096f, -0.232492f, 0.167415f, 0.392626f, 
    -0.410085f, -3.72529e-09f, 0.296792f, 4.65661e-10f, -0.263703f, -1.86265e-09f, 0.247703f, -1.86265e-09f, -0.239302f, -3.72529e-09f, 0.235591f, -3.72529e-09f, -0.235591f, 3.72529e-09f, 0.239302f, -3.72529e-09f, -0.247703f, 7.45058e-09f, 0.263703f, -3.72529e-09f, -0.296792f, 0.0f, 0.410085f, 
    0.392626f, -0.167415f, -0.232492f, 0.200096f, 0.160667f, -0.217744f, -0.107799f, 0.228166f, 0.0624857f, -0.2338f, -0.0205056f, 0.235591f, -0.0205056f, -0.2338f, 0.0624857f, 0.228166f, -0.107799f, -0.217744f, 0.160667f, 0.200096f, -0.232492f, -0.167415f, 0.392626f, 
    -0.344357f, 0.293665f, 0.0679698f, -0.280793f, 0.0684441f, 0.22917f, -0.155055f, -0.160092f, 0.208254f, 0.0820225f, -0.2338f, 0.0f, 0.2338f, -0.0820225f, -0.208254f, 0.160092f, 0.155055f, -0.22917f, -0.068444f, 0.280793f, -0.0679698f, -0.293665f, 0.344357f, 
    0.2761f, -0.353185f, 0.12716f, 0.196994f, -0.248563f, -0.0238188f, 0.247632f, -0.117663f, -0.174787f, 0.208254f, 0.0624857f, -0.239302f, 0.0624857f, 0.208254f, -0.174787f, -0.117663f, 0.247632f, -0.0238188f, -0.248563f, 0.196994f, 0.12716f, -0.353185f, 0.2761f, 
    -0.201636f, 0.343908f, -0.278595f, 9.31323e-10f, 0.247534f, -0.208738f, -0.0671711f, 0.249976f, -0.117663f, -0.160092f, 0.228166f, 0.0f, -0.228166f, 0.160092f, 0.117663f, -0.249976f, 0.0671711f, 0.208738f, -0.247534f, -3.72529e-09f, 0.278595f, -0.343908f, 0.201636f, 
    0.13337f, -0.284343f, 0.342223f, -0.20391f, -0.0701696f, 0.261342f, -0.192854f, -0.0671711f, 0.247632f, -0.155055f, -0.107799f, 0.247703f, -0.107799f, -0.155055f, 0.247632f, -0.0671711f, -0.192854f, 0.261342f, -0.0701697f, -0.20391f, 0.342223f, -0.284343f, 0.13337f, 
    -0.079234f, 0.202711f, -0.318f, 0.323043f, -0.162117f, -0.0917897f, 0.261342f, -0.208738f, -0.0238188f, 0.22917f, -0.217744f, 0.0f, 0.217744f, -0.22917f, 0.0238188f, 0.208738f, -0.261342f, 0.0917897f, 0.162117f, -0.323043f, 0.318f, -0.202711f, 0.079234f, 
    0.0417602f, -0.124645f, 0.239039f, -0.327749f, 0.313944f, -0.162117f, -0.0701696f, 0.247534f, -0.248563f, 0.0684441f, 0.160667f, -0.263703f, 0.160667f, 0.0684441f, -0.248563f, 0.247534f, -0.0701697f, -0.162117f, 0.313944f, -0.327749f, 0.239039f, -0.124645f, 0.0417602f, 
    -0.019161f, 0.0653617f, -0.1475f, 0.249987f, -0.327749f, 0.323043f, -0.20391f, 1.49012e-08f, 0.196994f, -0.280793f, 0.200096f, 0.0f, -0.200096f, 0.280793f, -0.196994f, 3.72529e-09f, 0.20391f, -0.323043f, 0.327749f, -0.249987f, 0.1475f, -0.0653617f, 0.019161f, 
    0.0074211f, -0.028479f, 0.0737278f, -0.1475f, 0.239039f, -0.318f, 0.342223f, -0.278595f, 0.12716f, 0.0679697f, -0.232492f, 0.296792f, -0.232492f, 0.0679698f, 0.12716f, -0.278595f, 0.342223f, -0.318f, 0.239039f, -0.1475f, 0.0737278f, -0.028479f, 0.0074211f, 
    -0.00229022f, 0.00976544f, -0.028479f, 0.0653617f, -0.124645f, 0.202711f, -0.284343f, 0.343908f, -0.353185f, 0.293665f, -0.167415f, 0.0f, 0.167415f, -0.293665f, 0.353185f, -0.343908f, 0.284343f, -0.202711f, 0.124645f, -0.0653617f, 0.028479f, -0.00976544f, 0.00229022f, 
    0.000488281f, -0.00229022f, 0.0074211f, -0.019161f, 0.0417602f, -0.079234f, 0.13337f, -0.201636f, 0.2761f, -0.344357f, 0.392626f, -0.410085f, 0.392626f, -0.344357f, 0.2761f, -0.201636f, 0.13337f, -0.079234f, 0.0417602f, -0.019161f, 0.0074211f, -0.00229022f, 0.000488281f };

static float wignerRef12[] = {  
    0.000244141f, 0.00119603f, 0.00405589f, 0.0109833f, 0.0251658f, 0.0503312f, 0.0895646f, 0.143622f, 0.209363f, 0.27915f, 0.341886f, 0.385699f, 0.401448f, 0.385699f, 0.341886f, 0.27915f, 0.209363f, 0.143622f, 0.0895646f, 0.0503312f, 0.0251658f, 0.0109833f, 0.00405589f, 0.00119603f, 0.000244141f, 
    -0.00119603f, -0.00537099f, -0.016558f, -0.0403549f, -0.0821903f, -0.143832f, -0.219386f, -0.293165f, -0.341885f, -0.341884f, -0.279146f, -0.15746f, -7.45058e-09f, 0.15746f, 0.279146f, 0.341884f, 0.341885f, 0.293165f, 0.219386f, 0.143832f, 0.0821903f, 0.0403549f, 0.016558f, 0.00537099f, 0.00119603f, 
    0.00405589f, 0.016558f, 0.0458967f, 0.099166f, 0.175714f, 0.26054f, 0.323463f, 0.328506f, 0.252039f, 0.100815f, -0.0823151f, -0.232159f, -0.289967f, -0.232159f, -0.0823151f, 0.100815f, 0.252039f, 0.328506f, 0.323463f, 0.26054f, 0.175714f, 0.099166f, 0.0458967f, 0.016558f, 0.00405589f, 
    -0.0109833f, -0.0403549f, -0.099166f, -0.186025f, -0.277444f, -0.328903f, -0.294633f, -0.159615f, 0.0372283f, 0.21096f, 0.273569f, 0.188606f, -4.65661e-10f, -0.188606f, -0.273569f, -0.21096f, -0.0372283f, 0.159615f, 0.294633f, 0.328903f, 0.277444f, 0.186025f, 0.099166f, 0.0403549f, 0.0109833f, 
    0.0251658f, 0.0821903f, 0.175714f, 0.277444f, 0.328591f, 0.271464f, 0.0990471f, -0.117031f, -0.2559f, -0.227466f, -0.0464313f, 0.164627f, 0.257024f, 0.164627f, -0.0464313f, -0.227466f, -0.2559f, -0.117031f, 0.0990472f, 0.271465f, 0.328591f, 0.277444f, 0.175714f, 0.0821903f, 0.0251658f, 
    -0.0503312f, -0.143832f, -0.26054f, -0.328903f, -0.271465f, -0.0786071f, 0.151176f, 0.263319f, 0.170599f, -0.0568662f, -0.232155f, -0.205783f, 7.45058e-09f, 0.205783f, 0.232155f, 0.0568662f, -0.170599f, -0.263318f, -0.151176f, 0.0786071f, 0.271465f, 0.328903f, 0.26054f, 0.143832f, 0.0503312f, 
    0.0895646f, 0.219386f, 0.323463f, 0.294633f, 0.0990472f, -0.151176f, -0.262672f, -0.137011f, 0.111846f, 0.244995f, 0.130459f, -0.115639f, -0.240723f, -0.115639f, 0.130459f, 0.244995f, 0.111846f, -0.137011f, -0.262672f, -0.151176f, 0.0990472f, 0.294633f, 0.323463f, 0.219386f, 0.0895646f, 
    -0.143622f, -0.293165f, -0.328506f, -0.159615f, 0.117031f, 0.263319f, 0.137011f, -0.128405f, -0.241982f, -0.0768647f, 0.174332f, 0.216341f, 2.79397e-09f, -0.216341f, -0.174332f, 0.0768647f, 0.241982f, 0.128405f, -0.137011f, -0.263319f, -0.117031f, 0.159616f, 0.328506f, 0.293165f, 0.143622f, 
    0.209363f, 0.341885f, 0.252039f, -0.0372283f, -0.2559f, -0.170599f, 0.111846f, 0.241982f, 0.0583434f, -0.196267f, -0.185365f, 0.0742039f, 0.231702f, 0.0742039f, -0.185365f, -0.196267f, 0.0583434f, 0.241982f, 0.111846f, -0.170599f, -0.2559f, -0.0372282f, 0.252039f, 0.341885f, 0.209363f, 
    -0.27915f, -0.341884f, -0.100815f, 0.21096f, 0.227466f, -0.0568662f, -0.244995f, -0.0768647f, 0.196267f, 0.172832f, -0.107631f, -0.222611f, 3.72529e-09f, 0.222611f, 0.107631f, -0.172832f, -0.196267f, 0.0768647f, 0.244995f, 0.0568662f, -0.227466f, -0.21096f, 0.100815f, 0.341884f, 0.27915f, 
    0.341886f, 0.279146f, -0.0823151f, -0.273569f, -0.0464313f, 0.232155f, 0.130459f, -0.174332f, -0.185365f, 0.107631f, 0.216771f, -0.0363522f, -0.227019f, -0.0363522f, 0.216771f, 0.107631f, -0.185365f, -0.174332f, 0.130459f, 0.232155f, -0.0464313f, -0.273569f, -0.082315f, 0.279146f, 0.341886f, 
    -0.385699f, -0.15746f, 0.232159f, 0.188606f, -0.164627f, -0.205783f, 0.115639f, 0.216341f, -0.0742039f, -0.222611f, 0.0363522f, 0.225559f, -5.58794e-09f, -0.225559f, -0.0363522f, 0.222611f, 0.0742039f, -0.216341f, -0.115639f, 0.205783f, 0.164627f, -0.188606f, -0.232159f, 0.15746f, 0.385699f, 
    0.401448f, 3.72529e-09f, -0.289967f, 4.65661e-10f, 0.257024f, 6.51926e-09f, -0.240723f, 4.65661e-09f, 0.231702f, -1.86265e-09f, -0.227019f, -1.86265e-09f, 0.225559f, 0.0f, -0.227019f, 0.0f, 0.231702f, 0.0f, -0.240723f, 1.49012e-08f, 0.257024f, 3.72529e-09f, -0.289967f, 3.72529e-09f, 0.401448f, 
    -0.385699f, 0.15746f, 0.232159f, -0.188606f, -0.164627f, 0.205783f, 0.115639f, -0.216341f, -0.0742039f, 0.222611f, 0.0363522f, -0.225559f, 0.0f, 0.225559f, -0.0363522f, -0.222611f, 0.0742039f, 0.21634f, -0.115639f, -0.205783f, 0.164627f, 0.188606f, -0.232159f, -0.15746f, 0.385699f, 
    0.341886f, -0.279146f, -0.082315f, 0.273569f, -0.0464312f, -0.232155f, 0.130459f, 0.174332f, -0.185365f, -0.107631f, 0.216771f, 0.0363522f, -0.227019f, 0.0363522f, 0.216771f, -0.107631f, -0.185365f, 0.174332f, 0.130459f, -0.232155f, -0.0464312f, 0.273569f, -0.0823151f, -0.279146f, 0.341886f, 
    -0.27915f, 0.341884f, -0.100815f, -0.21096f, 0.227466f, 0.0568662f, -0.244995f, 0.0768647f, 0.196267f, -0.172832f, -0.107631f, 0.222611f, 0.0f, -0.222611f, 0.107631f, 0.172832f, -0.196267f, -0.0768647f, 0.244995f, -0.0568662f, -0.227466f, 0.21096f, 0.100815f, -0.341884f, 0.27915f, 
    0.209363f, -0.341885f, 0.252039f, 0.0372283f, -0.2559f, 0.170599f, 0.111846f, -0.241982f, 0.0583434f, 0.196267f, -0.185365f, -0.0742039f, 0.231702f, -0.0742039f, -0.185365f, 0.196267f, 0.0583433f, -0.241982f, 0.111846f, 0.170599f, -0.2559f, 0.0372283f, 0.252039f, -0.341885f, 0.209363f, 
    -0.143622f, 0.293165f, -0.328506f, 0.159616f, 0.117031f, -0.263319f, 0.137011f, 0.128405f, -0.241982f, 0.0768647f, 0.174332f, -0.21634f, -1.11759e-08f, 0.216341f, -0.174332f, -0.0768647f, 0.241982f, -0.128405f, -0.137011f, 0.263319f, -0.117031f, -0.159615f, 0.328506f, -0.293165f, 0.143622f, 
    0.0895646f, -0.219386f, 0.323463f, -0.294633f, 0.0990472f, 0.151176f, -0.262672f, 0.137011f, 0.111846f, -0.244995f, 0.130459f, 0.115639f, -0.240723f, 0.115639f, 0.130459f, -0.244995f, 0.111846f, 0.137011f, -0.262672f, 0.151176f, 0.0990471f, -0.294633f, 0.323463f, -0.219386f, 0.0895646f, 
    -0.0503312f, 0.143832f, -0.26054f, 0.328903f, -0.271465f, 0.078607f, 0.151176f, -0.263319f, 0.170599f, 0.0568662f, -0.232155f, 0.205783f, -3.72529e-09f, -0.205783f, 0.232155f, -0.0568662f, -0.170599f, 0.263319f, -0.151176f, -0.078607f, 0.271465f, -0.328903f, 0.26054f, -0.143832f, 0.0503312f, 
    0.0251658f, -0.0821903f, 0.175714f, -0.277444f, 0.328591f, -0.271465f, 0.0990471f, 0.117031f, -0.2559f, 0.227466f, -0.0464312f, -0.164627f, 0.257024f, -0.164627f, -0.0464312f, 0.227466f, -0.2559f, 0.117031f, 0.0990471f, -0.271465f, 0.328591f, -0.277444f, 0.175714f, -0.0821903f, 0.0251658f, 
    -0.0109833f, 0.0403549f, -0.099166f, 0.186025f, -0.277444f, 0.328903f, -0.294633f, 0.159616f, 0.0372282f, -0.21096f, 0.273569f, -0.188606f, -3.72529e-09f, 0.188606f, -0.273569f, 0.21096f, -0.0372283f, -0.159615f, 0.294633f, -0.328903f, 0.277444f, -0.186025f, 0.099166f, -0.0403549f, 0.0109833f, 
    0.00405589f, -0.016558f, 0.0458967f, -0.0991659f, 0.175714f, -0.26054f, 0.323463f, -0.328506f, 0.252039f, -0.100815f, -0.082315f, 0.232159f, -0.289967f, 0.232159f, -0.082315f, -0.100815f, 0.252039f, -0.328506f, 0.323463f, -0.26054f, 0.175714f, -0.099166f, 0.0458967f, -0.016558f, 0.00405589f, 
    -0.00119603f, 0.00537099f, -0.016558f, 0.0403549f, -0.0821903f, 0.143832f, -0.219386f, 0.293165f, -0.341885f, 0.341884f, -0.279146f, 0.15746f, -3.72529e-09f, -0.15746f, 0.279146f, -0.341884f, 0.341885f, -0.293165f, 0.219386f, -0.143832f, 0.0821903f, -0.0403549f, 0.016558f, -0.00537099f, 0.00119603f, 
    0.000244141f, -0.00119603f, 0.00405589f, -0.0109833f, 0.0251658f, -0.0503312f, 0.0895646f, -0.143622f, 0.209363f, -0.27915f, 0.341886f, -0.385699f, 0.401448f, -0.385699f, 0.341886f, -0.27915f, 0.209363f, -0.143622f, 0.0895646f, -0.0503312f, 0.0251658f, -0.0109833f, 0.00405589f, -0.00119603f, 0.000244141f };

static float wignerRef13[] = {  
    0.00012207f, 0.000622433f, 0.00220061f, 0.00622422f, 0.0149251f, 0.0313068f, 0.0585694f, 0.0989999f, 0.152568f, 0.215764f, 0.281321f, 0.339285f, 0.379331f, 0.393651f, 0.379331f, 0.339285f, 0.281321f, 0.215764f, 0.152568f, 0.0989999f, 0.0585694f, 0.0313069f, 0.0149251f, 0.00622422f, 0.00220061f, 0.000622433f, 0.00012207f, 
    -0.000622433f, -0.00292963f, -0.00949457f, -0.0244132f, -0.0526863f, -0.0982355f, -0.160808f, -0.232983f, -0.299208f, -0.338515f, -0.331026f, -0.266154f, -0.148785f, -1.11759e-08f, 0.148785f, 0.266154f, 0.331026f, 0.338515f, 0.299208f, 0.232983f, 0.160808f, 0.0982355f, 0.0526863f, 0.0244132f, 0.00949457f, 0.00292963f, 0.000622433f, 
    0.00220061f, 0.00949457f, 0.0279531f, 0.064562f, 0.123354f, 0.199704f, 0.276147f, 0.323994f, 0.313124f, 0.227396f, 0.0780228f, -0.0940989f, -0.231452f, -0.28386f, -0.231452f, -0.0940989f, 0.0780228f, 0.227396f, 0.313124f, 0.323994f, 0.276147f, 0.199704f, 0.123354f, 0.064562f, 0.0279531f, 0.00949457f, 0.00220061f, 
    -0.00622422f, -0.0244132f, -0.064562f, -0.131829f, -0.217766f, -0.294702f, -0.321611f, -0.264043f, -0.119681f, 0.0677018f, 0.22068f, 0.26615f, 0.178539f, 0.0f, -0.178539f, -0.26615f, -0.22068f, -0.0677018f, 0.119681f, 0.264044f, 0.321611f, 0.294702f, 0.217766f, 0.131829f, 0.064562f, 0.0244132f, 0.00622422f, 
    0.0149251f, 0.0526863f, 0.123354f, 0.217766f, 0.29954f, 0.314927f, 0.22513f, 0.0437213f, -0.152226f, -0.25763f, -0.207066f, -0.0277478f, 0.167524f, 0.251114f, 0.167524f, -0.0277478f, -0.207066f, -0.25763f, -0.152226f, 0.0437213f, 0.22513f, 0.314927f, 0.29954f, 0.217766f, 0.123354f, 0.0526863f, 0.0149251f, 
    -0.0313068f, -0.0982355f, -0.199704f, -0.294702f, -0.314927f, -0.21092f, -0.00639388f, 0.191448f, 0.254592f, 0.134596f, -0.0833587f, -0.232816f, -0.195222f, 1.49012e-08f, 0.195222f, 0.232816f, 0.0833586f, -0.134596f, -0.254592f, -0.191448f, 0.0063939f, 0.21092f, 0.314927f, 0.294702f, 0.199704f, 0.0982355f, 0.0313068f, 
    0.0585694f, 0.160808f, 0.276147f, 0.321611f, 0.22513f, 0.00639389f, -0.202374f, -0.245517f, -0.0845757f, 0.144788f, 0.238027f, 0.108889f, -0.121741f, -0.234626f, -0.121741f, 0.108889f, 0.238027f, 0.144788f, -0.0845756f, -0.245516f, -0.202374f, 0.0063939f, 0.22513f, 0.321611f, 0.276147f, 0.160808f, 0.0585694f, 
    -0.0989999f, -0.232983f, -0.323994f, -0.264043f, -0.0437213f, 0.191448f, 0.245517f, 0.0673759f, -0.170045f, -0.225582f, -0.0416211f, 0.184055f, 0.20578f, 2.79397e-09f, -0.20578f, -0.184055f, 0.0416211f, 0.225582f, 0.170045f, -0.0673759f, -0.245517f, -0.191448f, 0.0437213f, 0.264044f, 0.323994f, 0.232983f, 0.0989999f, 
    0.152568f, 0.299208f, 0.313124f, 0.119681f, -0.152226f, -0.254592f, -0.0845756f, 0.170045f, 0.219092f, 0.00742238f, -0.208181f, -0.164217f, 0.0834543f, 0.225172f, 0.0834543f, -0.164217f, -0.208181f, 0.00742239f, 0.219092f, 0.170045f, -0.0845757f, -0.254592f, -0.152226f, 0.119681f, 0.313124f, 0.299208f, 0.152568f, 
    -0.215764f, -0.338515f, -0.227396f, 0.0677017f, 0.25763f, 0.134596f, -0.144788f, -0.225582f, -0.00742239f, 0.213842f, 0.138453f, -0.126674f, -0.212439f, -3.72529e-09f, 0.212439f, 0.126674f, -0.138453f, -0.213842f, 0.00742239f, 0.225582f, 0.144788f, -0.134596f, -0.25763f, -0.0677017f, 0.227396f, 0.338515f, 0.215764f, 
    0.281321f, 0.331026f, 0.0780229f, -0.22068f, -0.207066f, 0.0833586f, 0.238027f, 0.0416211f, -0.208181f, -0.138453f, 0.139509f, 0.199167f, -0.0488799f, -0.219809f, -0.0488799f, 0.199167f, 0.139509f, -0.138453f, -0.208181f, 0.0416211f, 0.238027f, 0.0833586f, -0.207066f, -0.22068f, 0.0780229f, 0.331026f, 0.281321f, 
    -0.339285f, -0.266154f, 0.0940989f, 0.26615f, 0.0277478f, -0.232816f, -0.108889f, 0.184055f, 0.164217f, -0.126674f, -0.199167f, 0.064445f, 0.216155f, -1.86265e-09f, -0.216155f, -0.0644449f, 0.199167f, 0.126674f, -0.164216f, -0.184055f, 0.108889f, 0.232816f, -0.0277478f, -0.26615f, -0.0940989f, 0.266154f, 0.339285f, 
    0.379331f, 0.148785f, -0.231452f, -0.178538f, 0.167524f, 0.195222f, -0.121741f, -0.20578f, 0.0834543f, 0.212439f, -0.0488799f, -0.216155f, 0.0161112f, 0.217352f, 0.0161112f, -0.216155f, -0.0488799f, 0.212439f, 0.0834543f, -0.20578f, -0.121741f, 0.195222f, 0.167524f, -0.178538f, -0.231452f, 0.148785f, 0.379331f, 
    -0.393651f, -3.72529e-09f, 0.28386f, -4.65661e-09f, -0.251114f, -5.58794e-09f, 0.234626f, 2.79397e-09f, -0.225172f, 3.72529e-09f, 0.219809f, 3.72529e-09f, -0.217352f, 0.0f, 0.217352f, -3.72529e-09f, -0.219809f, -7.45058e-09f, 0.225172f, -7.45058e-09f, -0.234626f, 7.45058e-09f, 0.251114f, 3.72529e-09f, -0.28386f, 3.72529e-09f, 0.393651f, 
    0.379331f, -0.148785f, -0.231452f, 0.178539f, 0.167524f, -0.195222f, -0.121741f, 0.20578f, 0.0834543f, -0.212439f, -0.0488799f, 0.216155f, 0.0161112f, -0.217352f, 0.0161112f, 0.216155f, -0.0488799f, -0.212439f, 0.0834543f, 0.20578f, -0.121741f, -0.195222f, 0.167524f, 0.178538f, -0.231452f, -0.148785f, 0.379331f, 
    -0.339285f, 0.266154f, 0.0940989f, -0.26615f, 0.0277478f, 0.232816f, -0.108889f, -0.184055f, 0.164217f, 0.126674f, -0.199167f, -0.0644449f, 0.216155f, -3.72529e-09f, -0.216155f, 0.0644449f, 0.199167f, -0.126674f, -0.164217f, 0.184055f, 0.108889f, -0.232816f, -0.0277478f, 0.26615f, -0.0940989f, -0.266154f, 0.339285f, 
    0.281321f, -0.331026f, 0.0780229f, 0.22068f, -0.207066f, -0.0833586f, 0.238027f, -0.0416211f, -0.208181f, 0.138453f, 0.139509f, -0.199167f, -0.0488799f, 0.219809f, -0.0488799f, -0.199167f, 0.139509f, 0.138453f, -0.208181f, -0.0416211f, 0.238027f, -0.0833587f, -0.207066f, 0.22068f, 0.0780229f, -0.331026f, 0.281321f, 
    -0.215764f, 0.338515f, -0.227396f, -0.0677018f, 0.25763f, -0.134596f, -0.144788f, 0.225582f, -0.00742239f, -0.213842f, 0.138453f, 0.126674f, -0.212439f, 0.0f, 0.212439f, -0.126674f, -0.138453f, 0.213842f, 0.00742239f, -0.225582f, 0.144788f, 0.134596f, -0.25763f, 0.0677018f, 0.227396f, -0.338515f, 0.215764f, 
    0.152568f, -0.299208f, 0.313124f, -0.119681f, -0.152226f, 0.254592f, -0.0845757f, -0.170045f, 0.219092f, -0.00742239f, -0.208181f, 0.164217f, 0.0834543f, -0.225172f, 0.0834543f, 0.164217f, -0.208181f, -0.00742239f, 0.219092f, -0.170045f, -0.0845756f, 0.254592f, -0.152226f, -0.119681f, 0.313124f, -0.299208f, 0.152568f, 
    -0.0989999f, 0.232984f, -0.323994f, 0.264044f, -0.0437213f, -0.191448f, 0.245517f, -0.0673759f, -0.170045f, 0.225582f, -0.0416211f, -0.184055f, 0.20578f, 3.72529e-09f, -0.20578f, 0.184055f, 0.0416211f, -0.225582f, 0.170045f, 0.0673759f, -0.245516f, 0.191448f, 0.0437213f, -0.264043f, 0.323994f, -0.232984f, 0.0989999f, 
    0.0585694f, -0.160808f, 0.276147f, -0.321611f, 0.22513f, -0.00639389f, -0.202374f, 0.245516f, -0.0845756f, -0.144788f, 0.238027f, -0.108889f, -0.121741f, 0.234626f, -0.121741f, -0.108889f, 0.238027f, -0.144788f, -0.0845756f, 0.245516f, -0.202374f, -0.00639387f, 0.22513f, -0.321611f, 0.276147f, -0.160808f, 0.0585694f, 
    -0.0313069f, 0.0982355f, -0.199704f, 0.294702f, -0.314927f, 0.21092f, -0.00639389f, -0.191448f, 0.254592f, -0.134596f, -0.0833586f, 0.232816f, -0.195222f, -3.72529e-09f, 0.195222f, -0.232816f, 0.0833586f, 0.134596f, -0.254592f, 0.191448f, 0.00639386f, -0.21092f, 0.314927f, -0.294702f, 0.199704f, -0.0982355f, 0.0313069f, 
    0.0149251f, -0.0526863f, 0.123354f, -0.217766f, 0.29954f, -0.314927f, 0.22513f, -0.0437213f, -0.152226f, 0.25763f, -0.207066f, 0.0277478f, 0.167524f, -0.251114f, 0.167524f, 0.0277478f, -0.207066f, 0.25763f, -0.152226f, -0.0437213f, 0.22513f, -0.314927f, 0.29954f, -0.217766f, 0.123354f, -0.0526863f, 0.0149251f, 
    -0.00622422f, 0.0244132f, -0.064562f, 0.131829f, -0.217766f, 0.294702f, -0.321611f, 0.264043f, -0.119681f, -0.0677018f, 0.22068f, -0.26615f, 0.178538f, 3.72529e-09f, -0.178538f, 0.26615f, -0.22068f, 0.0677018f, 0.119681f, -0.264043f, 0.321611f, -0.294702f, 0.217766f, -0.131829f, 0.064562f, -0.0244132f, 0.00622422f, 
    0.00220061f, -0.00949457f, 0.0279531f, -0.064562f, 0.123354f, -0.199704f, 0.276147f, -0.323994f, 0.313124f, -0.227396f, 0.0780229f, 0.0940989f, -0.231452f, 0.28386f, -0.231452f, 0.0940989f, 0.0780229f, -0.227396f, 0.313124f, -0.323994f, 0.276147f, -0.199704f, 0.123354f, -0.064562f, 0.0279531f, -0.00949457f, 0.00220061f, 
    -0.000622433f, 0.00292963f, -0.00949457f, 0.0244132f, -0.0526863f, 0.0982355f, -0.160808f, 0.232983f, -0.299208f, 0.338515f, -0.331026f, 0.266154f, -0.148785f, 3.72529e-09f, 0.148785f, -0.266154f, 0.331026f, -0.338515f, 0.299208f, -0.232984f, 0.160808f, -0.0982355f, 0.0526863f, -0.0244132f, 0.00949457f, -0.00292963f, 0.000622433f, 
    0.00012207f, -0.000622433f, 0.00220061f, -0.00622422f, 0.0149251f, -0.0313068f, 0.0585694f, -0.0989999f, 0.152568f, -0.215764f, 0.281321f, -0.339285f, 0.379331f, -0.393651f, 0.379331f, -0.339285f, 0.281321f, -0.215764f, 0.152568f, -0.0989999f, 0.0585694f, -0.0313069f, 0.0149251f, -0.00622422f, 0.00220061f, -0.000622433f, 0.00012207f };

static float wignerRef14[] = {  
    6.10352e-05f, 0.000322965f, 0.00118664f, 0.00349334f, 0.00873327f, 0.0191335f, 0.0374611f, 0.0664111f, 0.107598f, 0.160397f, 0.221091f, 0.28282f, 0.336622f, 0.373448f, 0.386555f, 0.373448f, 0.336622f, 0.28282f, 0.221091f, 0.160397f, 0.107598f, 0.0664111f, 0.0374611f, 0.0191335f, 0.00873327f, 0.00349334f, 0.00118664f, 0.000322965f, 6.10352e-05f, 
    -0.000322965f, -0.00158688f, -0.00538203f, -0.0145238f, -0.0330084f, -0.0650855f, -0.113271f, -0.175705f, -0.244006f, -0.303118f, -0.334255f, -0.320684f, -0.25446f, -0.141149f, -1.11759e-08f, 0.141149f, 0.25446f, 0.320684f, 0.334255f, 0.303118f, 0.244006f, 0.175705f, 0.113271f, 0.0650855f, 0.0330084f, 0.0145238f, 0.00538203f, 0.00158688f, 0.000322965f, 
    0.00118664f, 0.00538203f, 0.016723f, 0.0409658f, 0.083548f, 0.145647f, 0.21965f, 0.286923f, 0.320979f, 0.296991f, 0.204686f, 0.0581856f, -0.103882f, -0.230493f, -0.278347f, -0.230493f, -0.103882f, 0.0581856f, 0.204686f, 0.296991f, 0.320979f, 0.286923f, 0.21965f, 0.145647f, 0.083548f, 0.0409658f, 0.016723f, 0.00538203f, 0.00118664f, 
    -0.00349334f, -0.0145238f, -0.0409658f, -0.089961f, -0.161733f, -0.242688f, -0.303679f, -0.30863f, -0.233099f, -0.0840684f, 0.092704f, 0.227292f, 0.258769f, 0.169637f, -2.32831e-10f, -0.169637f, -0.258769f, -0.227292f, -0.092704f, 0.0840684f, 0.233099f, 0.30863f, 0.303679f, 0.242688f, 0.161733f, 0.089961f, 0.0409658f, 0.0145238f, 0.00349334f, 
    0.00873327f, 0.0330084f, 0.083548f, 0.161733f, 0.249678f, 0.308204f, 0.291896f, 0.178679f, -0.00375964f, -0.178224f, -0.254934f, -0.187761f, -0.0117621f, 0.169636f, 0.245825f, 0.169636f, -0.0117621f, -0.187761f, -0.254934f, -0.178224f, -0.00375965f, 0.178679f, 0.291896f, 0.308205f, 0.249678f, 0.161733f, 0.083548f, 0.0330084f, 0.00873327f, 
    -0.0191335f, -0.0650855f, -0.145647f, -0.242688f, -0.308204f, -0.284889f, -0.149123f, 0.0533815f, 0.216905f, 0.239437f, 0.101551f, -0.104645f, -0.231924f, -0.185825f, 1.11759e-08f, 0.185825f, 0.231924f, 0.104645f, -0.101551f, -0.239437f, -0.216905f, -0.0533815f, 0.149123f, 0.284889f, 0.308205f, 0.242688f, 0.145647f, 0.0650855f, 0.0191335f, 
    0.0374611f, 0.113271f, 0.21965f, 0.303679f, 0.291896f, 0.149123f, -0.0690853f, -0.230235f, -0.218063f, -0.0376285f, 0.168568f, 0.228533f, 0.0899383f, -0.126547f, -0.22923f, -0.126547f, 0.0899384f, 0.228533f, 0.168568f, -0.0376284f, -0.218063f, -0.230235f, -0.0690853f, 0.149123f, 0.291896f, 0.303679f, 0.21965f, 0.113271f, 0.0374611f, 
    -0.0664111f, -0.175705f, -0.286923f, -0.30863f, -0.178679f, 0.0533815f, 0.230235f, 0.209207f, 0.00553713f, -0.196333f, -0.204798f, -0.0114355f, 0.190554f, 0.1963f, -3.72529e-09f, -0.1963f, -0.190554f, 0.0114355f, 0.204798f, 0.196333f, -0.00553713f, -0.209207f, -0.230235f, -0.0533815f, 0.178679f, 0.30863f, 0.286923f, 0.175705f, 0.0664111f, 
    0.107598f, 0.244006f, 0.320979f, 0.233099f, -0.00375963f, -0.216905f, -0.218063f, -0.00553713f, 0.203651f, 0.1875f, -0.0349867f, -0.213508f, -0.144914f, 0.0908689f, 0.219469f, 0.0908689f, -0.144914f, -0.213508f, -0.0349866f, 0.1875f, 0.203651f, -0.00553713f, -0.218063f, -0.216905f, -0.00375962f, 0.233099f, 0.320979f, 0.244006f, 0.107598f, 
    -0.160397f, -0.303118f, -0.296991f, -0.0840684f, 0.178224f, 0.239437f, 0.0376285f, -0.196333f, -0.1875f, 0.0499207f, 0.218714f, 0.106531f, -0.140886f, -0.203188f, -1.39698e-08f, 0.203188f, 0.140886f, -0.106531f, -0.218714f, -0.0499207f, 0.1875f, 0.196333f, -0.0376285f, -0.239437f, -0.178224f, 0.0840684f, 0.296991f, 0.303118f, 0.160397f, 
    0.221091f, 0.334255f, 0.204686f, -0.0927039f, -0.254934f, -0.101551f, 0.168568f, 0.204798f, -0.0349867f, -0.218714f, -0.0928836f, 0.161441f, 0.181932f, -0.0589631f, -0.213614f, -0.0589631f, 0.181932f, 0.161441f, -0.0928836f, -0.218714f, -0.0349866f, 0.204798f, 0.168568f, -0.101551f, -0.254934f, -0.0927039f, 0.204686f, 0.334255f, 0.221091f, 
    -0.28282f, -0.320684f, -0.0581856f, 0.227292f, 0.187761f, -0.104645f, -0.228533f, -0.0114355f, 0.213508f, 0.106531f, -0.161441f, -0.173195f, 0.0862922f, 0.20742f, -5.58794e-09f, -0.20742f, -0.0862922f, 0.173195f, 0.161441f, -0.106531f, -0.213508f, 0.0114355f, 0.228533f, 0.104645f, -0.187761f, -0.227292f, 0.0581856f, 0.320684f, 0.28282f, 
    0.336622f, 0.25446f, -0.103882f, -0.258769f, -0.0117621f, 0.231924f, 0.0899384f, -0.190554f, -0.144914f, 0.140886f, 0.181932f, -0.0862922f, -0.203402f, 0.0290446f, 0.210448f, 0.0290446f, -0.203402f, -0.0862922f, 0.181932f, 0.140886f, -0.144914f, -0.190554f, 0.0899384f, 0.231924f, -0.0117621f, -0.258769f, -0.103882f, 0.25446f, 0.336622f, 
    -0.373448f, -0.141149f, 0.230493f, 0.169637f, -0.169636f, -0.185825f, 0.126547f, 0.1963f, -0.0908688f, -0.203188f, 0.0589631f, 0.20742f, -0.0290446f, -0.209444f, -1.86265e-09f, 0.209444f, 0.0290446f, -0.20742f, -0.0589631f, 0.203188f, 0.0908688f, -0.1963f, -0.126547f, 0.185825f, 0.169636f, -0.169637f, -0.230493f, 0.141149f, 0.373448f, 
    0.386555f, 0.0f, -0.278347f, 6.51926e-09f, 0.245825f, 6.51926e-09f, -0.22923f, -9.31323e-10f, 0.219469f, -2.79397e-09f, -0.213614f, -1.86265e-09f, 0.210448f, -1.86265e-09f, -0.209443f, 3.72529e-09f, 0.210448f, -3.72529e-09f, -0.213614f, -3.72529e-09f, 0.219469f, -3.72529e-09f, -0.22923f, 3.72529e-09f, 0.245825f, -7.45058e-09f, -0.278347f, -3.72529e-09f, 0.386555f, 
    -0.373448f, 0.141149f, 0.230493f, -0.169637f, -0.169636f, 0.185825f, 0.126547f, -0.1963f, -0.0908688f, 0.203188f, 0.0589631f, -0.20742f, -0.0290446f, 0.209444f, 0.0f, -0.209444f, 0.0290446f, 0.20742f, -0.0589631f, -0.203188f, 0.0908688f, 0.1963f, -0.126547f, -0.185825f, 0.169636f, 0.169637f, -0.230493f, -0.141149f, 0.373448f, 
    0.336622f, -0.25446f, -0.103882f, 0.258769f, -0.0117621f, -0.231924f, 0.0899384f, 0.190554f, -0.144914f, -0.140886f, 0.181932f, 0.0862922f, -0.203402f, -0.0290446f, 0.210448f, -0.0290446f, -0.203402f, 0.0862922f, 0.181932f, -0.140886f, -0.144914f, 0.190554f, 0.0899384f, -0.231924f, -0.0117621f, 0.258769f, -0.103882f, -0.25446f, 0.336622f, 
    -0.28282f, 0.320684f, -0.0581856f, -0.227292f, 0.187761f, 0.104645f, -0.228533f, 0.0114355f, 0.213508f, -0.106531f, -0.161441f, 0.173195f, 0.0862922f, -0.20742f, 3.72529e-09f, 0.20742f, -0.0862922f, -0.173195f, 0.161441f, 0.106531f, -0.213508f, -0.0114355f, 0.228533f, -0.104645f, -0.187761f, 0.227292f, 0.0581856f, -0.320684f, 0.28282f, 
    0.221091f, -0.334255f, 0.204686f, 0.092704f, -0.254934f, 0.101551f, 0.168568f, -0.204798f, -0.0349866f, 0.218714f, -0.0928836f, -0.161441f, 0.181932f, 0.0589631f, -0.213614f, 0.0589631f, 0.181932f, -0.161441f, -0.0928836f, 0.218714f, -0.0349866f, -0.204798f, 0.168568f, 0.101551f, -0.254934f, 0.0927039f, 0.204686f, -0.334255f, 0.221091f, 
    -0.160397f, 0.303118f, -0.296991f, 0.0840684f, 0.178224f, -0.239437f, 0.0376285f, 0.196333f, -0.1875f, -0.0499207f, 0.218714f, -0.106531f, -0.140886f, 0.203188f, 3.72529e-09f, -0.203188f, 0.140886f, 0.106531f, -0.218714f, 0.0499207f, 0.1875f, -0.196333f, -0.0376285f, 0.239437f, -0.178224f, -0.0840684f, 0.296991f, -0.303118f, 0.160397f, 
    0.107598f, -0.244006f, 0.320979f, -0.233099f, -0.00375963f, 0.216905f, -0.218063f, 0.00553714f, 0.203651f, -0.1875f, -0.0349866f, 0.213508f, -0.144914f, -0.0908689f, 0.219469f, -0.0908688f, -0.144914f, 0.213508f, -0.0349866f, -0.1875f, 0.203651f, 0.00553713f, -0.218063f, 0.216905f, -0.00375964f, -0.233099f, 0.320979f, -0.244006f, 0.107598f, 
    -0.0664111f, 0.175705f, -0.286923f, 0.30863f, -0.178679f, -0.0533815f, 0.230235f, -0.209207f, 0.00553713f, 0.196333f, -0.204798f, 0.0114355f, 0.190554f, -0.1963f, -3.72529e-09f, 0.1963f, -0.190554f, -0.0114355f, 0.204798f, -0.196333f, -0.00553712f, 0.209207f, -0.230235f, 0.0533815f, 0.178679f, -0.30863f, 0.286923f, -0.175706f, 0.0664111f, 
    0.0374611f, -0.113271f, 0.21965f, -0.303679f, 0.291896f, -0.149123f, -0.0690853f, 0.230235f, -0.218063f, 0.0376284f, 0.168568f, -0.228533f, 0.0899384f, 0.126547f, -0.22923f, 0.126547f, 0.0899384f, -0.228533f, 0.168568f, 0.0376284f, -0.218063f, 0.230235f, -0.0690853f, -0.149123f, 0.291896f, -0.303679f, 0.21965f, -0.113271f, 0.0374611f, 
    -0.0191335f, 0.0650855f, -0.145647f, 0.242688f, -0.308205f, 0.284889f, -0.149123f, -0.0533815f, 0.216905f, -0.239437f, 0.101551f, 0.104645f, -0.231924f, 0.185825f, 0.0f, -0.185825f, 0.231924f, -0.104645f, -0.101551f, 0.239437f, -0.216905f, 0.0533815f, 0.149123f, -0.284889f, 0.308205f, -0.242688f, 0.145647f, -0.0650855f, 0.0191335f, 
    0.00873327f, -0.0330084f, 0.083548f, -0.161733f, 0.249678f, -0.308205f, 0.291896f, -0.178679f, -0.00375962f, 0.178224f, -0.254934f, 0.187761f, -0.0117621f, -0.169636f, 0.245825f, -0.169636f, -0.0117621f, 0.187761f, -0.254934f, 0.178224f, -0.00375964f, -0.178679f, 0.291896f, -0.308205f, 0.249678f, -0.161733f, 0.083548f, -0.0330084f, 0.00873327f, 
    -0.00349334f, 0.0145238f, -0.0409658f, 0.089961f, -0.161733f, 0.242688f, -0.303679f, 0.30863f, -0.233099f, 0.0840684f, 0.0927039f, -0.227292f, 0.258769f, -0.169637f, 3.72529e-09f, 0.169637f, -0.258769f, 0.227292f, -0.0927039f, -0.0840684f, 0.233099f, -0.30863f, 0.303679f, -0.242688f, 0.161733f, -0.089961f, 0.0409658f, -0.0145238f, 0.00349334f, 
    0.00118664f, -0.00538203f, 0.016723f, -0.0409658f, 0.083548f, -0.145647f, 0.21965f, -0.286923f, 0.320979f, -0.296991f, 0.204686f, -0.0581856f, -0.103882f, 0.230493f, -0.278347f, 0.230493f, -0.103882f, -0.0581856f, 0.204686f, -0.296991f, 0.320979f, -0.286923f, 0.21965f, -0.145647f, 0.083548f, -0.0409658f, 0.016723f, -0.00538203f, 0.00118664f, 
    -0.000322965f, 0.00158688f, -0.00538203f, 0.0145238f, -0.0330084f, 0.0650855f, -0.113271f, 0.175705f, -0.244006f, 0.303118f, -0.334255f, 0.320684f, -0.25446f, 0.141149f, 0.0f, -0.141149f, 0.25446f, -0.320684f, 0.334255f, -0.303118f, 0.244006f, -0.175706f, 0.113271f, -0.0650855f, 0.0330084f, -0.0145238f, 0.00538203f, -0.00158688f, 0.000322965f, 
    6.10352e-05f, -0.000322965f, 0.00118664f, -0.00349334f, 0.00873327f, -0.0191335f, 0.0374611f, -0.0664111f, 0.107598f, -0.160397f, 0.221091f, -0.28282f, 0.336622f, -0.373448f, 0.386555f, -0.373448f, 0.336622f, -0.28282f, 0.221091f, -0.160397f, 0.107598f, -0.0664111f, 0.0374611f, -0.0191335f, 0.00873327f, -0.00349334f, 0.00118664f, -0.000322965f, 6.10352e-05f };

static float wignerRef15[] = {  
    3.05176e-05f, 0.00016715f, 0.000636483f, 0.00194447f, 0.00505184f, 0.0115199f, 0.0235147f, 0.0435406f, 0.0738263f, 0.115425f, 0.167266f, 0.225541f, 0.283798f, 0.333944f, 0.367988f, 0.380056f, 0.367988f, 0.333944f, 0.283798f, 0.225541f, 0.167266f, 0.115425f, 0.0738263f, 0.0435406f, 0.0235147f, 0.0115199f, 0.00505184f, 0.00194447f, 0.000636483f, 0.00016715f, 3.05176e-05f, 
    -0.00016715f, -0.000854476f, -0.00302131f, -0.00852016f, -0.0202912f, -0.0420643f, -0.0772766f, -0.127189f, -0.188701f, -0.252881f, -0.305381f, -0.32942f, -0.310883f, -0.243876f, -0.134369f, -7.45058e-09f, 0.134369f, 0.243876f, 0.310883f, 0.32942f, 0.305381f, 0.252881f, 0.188701f, 0.127189f, 0.0772766f, 0.0420643f, 0.0202912f, 0.00852016f, 0.00302131f, 0.000854476f, 0.00016715f, 
    0.000636483f, 0.00302131f, 0.00985681f, 0.0254514f, 0.0549823f, 0.10218f, 0.165731f, 0.235896f, 0.29379f, 0.315443f, 0.280687f, 0.183832f, 0.0408205f, -0.112078f, -0.229364f, -0.27333f, -0.229364f, -0.112078f, 0.0408205f, 0.183832f, 0.280687f, 0.315443f, 0.29379f, 0.235896f, 0.165731f, 0.10218f, 0.0549823f, 0.0254514f, 0.00985681f, 0.00302131f, 0.000636483f, 
    -0.00194447f, -0.00852016f, -0.0254514f, -0.0595671f, -0.115118f, -0.188021f, -0.261276f, -0.306124f, -0.291969f, -0.202882f, -0.0525004f, 0.113266f, 0.2316f, 0.251559f, 0.161703f, 0.0f, -0.161703f, -0.251559f, -0.2316f, -0.113266f, 0.0525004f, 0.202882f, 0.291969f, 0.306124f, 0.261276f, 0.188021f, 0.115118f, 0.0595671f, 0.0254514f, 0.00852016f, 0.00194447f, 
    0.00505184f, 0.0202912f, 0.0549823f, 0.115118f, 0.195208f, 0.271731f, 0.30638f, 0.263268f, 0.134229f, -0.0439248f, -0.197021f, -0.249314f, -0.169713f, 0.00201716f, 0.171157f, 0.24105f, 0.171157f, 0.00201717f, -0.169713f, -0.249314f, -0.197021f, -0.0439248f, 0.134229f, 0.263268f, 0.30638f, 0.271731f, 0.195208f, 0.115118f, 0.0549823f, 0.0202912f, 0.00505184f, 
    -0.0115199f, -0.0420643f, -0.10218f, -0.188021f, -0.271731f, -0.305272f, -0.24554f, -0.0904224f, 0.101299f, 0.231146f, 0.220649f, 0.0716921f, -0.121784f, -0.229992f, -0.177407f, 6.98492e-09f, 0.177407f, 0.229992f, 0.121784f, -0.0716921f, -0.220649f, -0.231146f, -0.101299f, 0.0904224f, 0.24554f, 0.305273f, 0.271731f, 0.188021f, 0.10218f, 0.0420643f, 0.0115199f, 
    0.0235147f, 0.0772766f, 0.165731f, 0.261276f, 0.30638f, 0.24554f, 0.0756458f, -0.12696f, -0.240753f, -0.185583f, 0.00325587f, 0.185267f, 0.217654f, 0.0732367f, -0.130366f, -0.224403f, -0.130366f, 0.0732367f, 0.217654f, 0.185266f, 0.00325587f, -0.185583f, -0.240753f, -0.12696f, 0.0756459f, 0.24554f, 0.30638f, 0.261276f, 0.165731f, 0.0772766f, 0.0235147f, 
    -0.0435406f, -0.127189f, -0.235896f, -0.306124f, -0.263268f, -0.0904224f, 0.12696f, 0.242162f, 0.164324f, -0.0465941f, -0.211003f, -0.18209f, 0.0143203f, 0.194718f, 0.187748f, 4.65661e-09f, -0.187748f, -0.194718f, -0.0143203f, 0.18209f, 0.211003f, 0.0465941f, -0.164324f, -0.242162f, -0.12696f, 0.0904224f, 0.263268f, 0.306124f, 0.235896f, 0.127189f, 0.0435406f, 
    0.0738263f, 0.188701f, 0.29379f, 0.291969f, 0.134229f, -0.101299f, -0.240753f, -0.164324f, 0.0604483f, 0.218549f, 0.152442f, -0.069636f, -0.214307f, -0.127398f, 0.0968861f, 0.214422f, 0.0968861f, -0.127398f, -0.214307f, -0.069636f, 0.152442f, 0.218549f, 0.0604483f, -0.164324f, -0.240753f, -0.101299f, 0.134229f, 0.291969f, 0.29379f, 0.188701f, 0.0738263f, 
    -0.115425f, -0.252881f, -0.315443f, -0.202882f, 0.0439248f, 0.231146f, 0.185583f, -0.0465941f, -0.218549f, -0.141462f, 0.0950697f, 0.215123f, 0.0775759f, -0.151491f, -0.194757f, -5.58794e-09f, 0.194757f, 0.151491f, -0.0775759f, -0.215123f, -0.0950697f, 0.141462f, 0.218549f, 0.0465941f, -0.185583f, -0.231146f, -0.0439248f, 0.202882f, 0.315443f, 0.252881f, 0.115425f, 
    0.167266f, 0.305381f, 0.280687f, 0.0525004f, -0.197021f, -0.220649f, 0.00325587f, 0.211003f, 0.152442f, -0.0950697f, -0.213625f, -0.0511424f, 0.175973f, 0.165519f, -0.0671975f, -0.208204f, -0.0671975f, 0.165519f, 0.175973f, -0.0511424f, -0.213625f, -0.0950697f, 0.152442f, 0.211003f, 0.00325585f, -0.220649f, -0.197021f, 0.0525004f, 0.280687f, 0.305381f, 0.167266f, 
    -0.225541f, -0.32942f, -0.183832f, 0.113266f, 0.249314f, 0.0716921f, -0.185266f, -0.18209f, 0.069636f, 0.215123f, 0.0511424f, -0.182592f, -0.146976f, 0.10337f, 0.199339f, -7.45058e-09f, -0.199339f, -0.10337f, 0.146976f, 0.182592f, -0.0511424f, -0.215123f, -0.0696359f, 0.18209f, 0.185266f, -0.0716921f, -0.249314f, -0.113266f, 0.183832f, 0.32942f, 0.225541f, 
    0.283798f, 0.310883f, 0.0408205f, -0.2316f, -0.169713f, 0.121784f, 0.217654f, -0.0143203f, -0.214307f, -0.0775759f, 0.175973f, 0.146976f, -0.114455f, -0.189972f, 0.0396046f, 0.204517f, 0.0396046f, -0.189972f, -0.114455f, 0.146976f, 0.175973f, -0.0775759f, -0.214307f, -0.0143203f, 0.217654f, 0.121784f, -0.169713f, -0.2316f, 0.0408205f, 0.310883f, 0.283798f, 
    -0.333944f, -0.243876f, 0.112078f, 0.251559f, -0.00201716f, -0.229992f, -0.0732367f, 0.194718f, 0.127398f, -0.151491f, -0.165519f, 0.10337f, 0.189972f, -0.0523605f, -0.201944f, 0.0f, 0.201944f, 0.0523605f, -0.189972f, -0.10337f, 0.165519f, 0.151491f, -0.127398f, -0.194718f, 0.0732367f, 0.229992f, 0.00201717f, -0.251559f, -0.112078f, 0.243876f, 0.333944f, 
    0.367988f, 0.134369f, -0.229364f, -0.161703f, 0.171157f, 0.177407f, -0.130366f, -0.187748f, 0.0968861f, 0.194757f, -0.0671975f, -0.199339f, 0.0396046f, 0.201944f, -0.0130901f, -0.202791f, -0.0130901f, 0.201944f, 0.0396046f, -0.199339f, -0.0671975f, 0.194757f, 0.0968861f, -0.187748f, -0.130366f, 0.177407f, 0.171157f, -0.161703f, -0.229364f, 0.134369f, 0.367988f, 
    -0.380056f, -3.72529e-09f, 0.27333f, -7.21775e-09f, -0.24105f, -6.51926e-09f, 0.224403f, 0.0f, -0.214422f, -9.31323e-10f, 0.208204f, -1.86265e-09f, -0.204517f, -3.72529e-09f, 0.202791f, -1.86265e-09f, -0.202791f, 5.58794e-09f, 0.204517f, 0.0f, -0.208204f, -3.72529e-09f, 0.214422f, -3.72529e-09f, -0.224403f, 0.0f, 0.24105f, -3.72529e-09f, -0.27333f, 0.0f, 0.380056f, 
    0.367988f, -0.134369f, -0.229364f, 0.161703f, 0.171157f, -0.177407f, -0.130366f, 0.187748f, 0.0968861f, -0.194757f, -0.0671975f, 0.199339f, 0.0396046f, -0.201944f, -0.0130901f, 0.202791f, -0.0130901f, -0.201944f, 0.0396046f, 0.199339f, -0.0671975f, -0.194757f, 0.0968861f, 0.187748f, -0.130366f, -0.177407f, 0.171157f, 0.161703f, -0.229364f, -0.134369f, 0.367988f, 
    -0.333944f, 0.243876f, 0.112078f, -0.251559f, -0.00201718f, 0.229992f, -0.0732367f, -0.194718f, 0.127398f, 0.151491f, -0.165519f, -0.10337f, 0.189972f, 0.0523605f, -0.201944f, 3.72529e-09f, 0.201944f, -0.0523605f, -0.189972f, 0.10337f, 0.165519f, -0.151491f, -0.127398f, 0.194718f, 0.0732367f, -0.229992f, 0.00201717f, 0.251559f, -0.112078f, -0.243876f, 0.333944f, 
    0.283798f, -0.310883f, 0.0408205f, 0.2316f, -0.169713f, -0.121784f, 0.217654f, 0.0143203f, -0.214307f, 0.0775759f, 0.175973f, -0.146976f, -0.114455f, 0.189972f, 0.0396046f, -0.204517f, 0.0396046f, 0.189972f, -0.114455f, -0.146976f, 0.175973f, 0.0775759f, -0.214307f, 0.0143203f, 0.217654f, -0.121784f, -0.169713f, 0.2316f, 0.0408205f, -0.310883f, 0.283798f, 
    -0.225541f, 0.32942f, -0.183832f, -0.113266f, 0.249314f, -0.0716921f, -0.185266f, 0.18209f, 0.069636f, -0.215123f, 0.0511424f, 0.182592f, -0.146976f, -0.10337f, 0.199339f, 3.72529e-09f, -0.199339f, 0.10337f, 0.146976f, -0.182592f, -0.0511424f, 0.215123f, -0.069636f, -0.18209f, 0.185266f, 0.0716921f, -0.249314f, 0.113266f, 0.183832f, -0.32942f, 0.225541f, 
    0.167266f, -0.305381f, 0.280687f, -0.0525004f, -0.197021f, 0.220649f, 0.00325586f, -0.211003f, 0.152442f, 0.0950697f, -0.213625f, 0.0511424f, 0.175973f, -0.165519f, -0.0671975f, 0.208204f, -0.0671975f, -0.165519f, 0.175973f, 0.0511424f, -0.213625f, 0.0950697f, 0.152442f, -0.211003f, 0.00325587f, 0.220649f, -0.197021f, -0.0525004f, 0.280687f, -0.305381f, 0.167266f, 
    -0.115425f, 0.252881f, -0.315443f, 0.202882f, 0.0439248f, -0.231146f, 0.185583f, 0.0465941f, -0.218548f, 0.141462f, 0.0950697f, -0.215123f, 0.0775759f, 0.151491f, -0.194757f, 0.0f, 0.194757f, -0.151491f, -0.0775759f, 0.215123f, -0.0950697f, -0.141462f, 0.218548f, -0.0465941f, -0.185583f, 0.231146f, -0.0439248f, -0.202882f, 0.315443f, -0.252881f, 0.115425f, 
    0.0738263f, -0.188701f, 0.29379f, -0.291969f, 0.134229f, 0.101299f, -0.240753f, 0.164324f, 0.0604483f, -0.218548f, 0.152442f, 0.069636f, -0.214307f, 0.127398f, 0.0968861f, -0.214422f, 0.0968861f, 0.127398f, -0.214307f, 0.069636f, 0.152442f, -0.218549f, 0.0604483f, 0.164324f, -0.240753f, 0.101299f, 0.134229f, -0.291969f, 0.29379f, -0.188701f, 0.0738263f, 
    -0.0435406f, 0.127189f, -0.235896f, 0.306124f, -0.263268f, 0.0904224f, 0.12696f, -0.242162f, 0.164324f, 0.0465941f, -0.211003f, 0.18209f, 0.0143203f, -0.194718f, 0.187748f, 0.0f, -0.187748f, 0.194718f, -0.0143203f, -0.18209f, 0.211003f, -0.0465941f, -0.164324f, 0.242162f, -0.12696f, -0.0904224f, 0.263268f, -0.306124f, 0.235896f, -0.127189f, 0.0435406f, 
    0.0235147f, -0.0772766f, 0.165731f, -0.261276f, 0.30638f, -0.24554f, 0.0756458f, 0.12696f, -0.240753f, 0.185583f, 0.00325587f, -0.185266f, 0.217654f, -0.0732367f, -0.130366f, 0.224403f, -0.130366f, -0.0732367f, 0.217654f, -0.185266f, 0.00325588f, 0.185583f, -0.240753f, 0.12696f, 0.0756458f, -0.24554f, 0.30638f, -0.261276f, 0.165731f, -0.0772766f, 0.0235147f, 
    -0.0115199f, 0.0420643f, -0.10218f, 0.188021f, -0.271731f, 0.305273f, -0.24554f, 0.0904224f, 0.101299f, -0.231146f, 0.220649f, -0.0716921f, -0.121784f, 0.229992f, -0.177407f, 0.0f, 0.177407f, -0.229992f, 0.121784f, 0.0716921f, -0.220649f, 0.231146f, -0.101299f, -0.0904224f, 0.24554f, -0.305273f, 0.271731f, -0.188021f, 0.10218f, -0.0420643f, 0.0115199f, 
    0.00505184f, -0.0202912f, 0.0549823f, -0.115118f, 0.195207f, -0.271731f, 0.30638f, -0.263268f, 0.134229f, 0.0439248f, -0.197021f, 0.249314f, -0.169713f, -0.00201718f, 0.171157f, -0.24105f, 0.171157f, -0.00201717f, -0.169713f, 0.249314f, -0.197021f, 0.0439248f, 0.134229f, -0.263268f, 0.30638f, -0.271731f, 0.195208f, -0.115118f, 0.0549823f, -0.0202912f, 0.00505184f, 
    -0.00194447f, 0.00852016f, -0.0254514f, 0.0595671f, -0.115118f, 0.188021f, -0.261276f, 0.306124f, -0.291969f, 0.202882f, -0.0525004f, -0.113266f, 0.2316f, -0.251559f, 0.161703f, 0.0f, -0.161703f, 0.251559f, -0.2316f, 0.113266f, 0.0525004f, -0.202882f, 0.291969f, -0.306124f, 0.261276f, -0.188021f, 0.115118f, -0.0595671f, 0.0254514f, -0.00852016f, 0.00194447f, 
    0.000636483f, -0.00302131f, 0.00985681f, -0.0254514f, 0.0549823f, -0.10218f, 0.165731f, -0.235896f, 0.29379f, -0.315443f, 0.280687f, -0.183832f, 0.0408205f, 0.112078f, -0.229364f, 0.27333f, -0.229364f, 0.112078f, 0.0408205f, -0.183832f, 0.280687f, -0.315443f, 0.29379f, -0.235896f, 0.165731f, -0.10218f, 0.0549823f, -0.0254514f, 0.00985681f, -0.00302131f, 0.000636483f, 
    -0.00016715f, 0.000854476f, -0.00302131f, 0.00852016f, -0.0202912f, 0.0420643f, -0.0772766f, 0.127189f, -0.188701f, 0.252881f, -0.305381f, 0.32942f, -0.310883f, 0.243876f, -0.134369f, 0.0f, 0.134369f, -0.243876f, 0.310883f, -0.32942f, 0.305381f, -0.252881f, 0.188701f, -0.127189f, 0.0772766f, -0.0420643f, 0.0202912f, -0.00852016f, 0.00302131f, -0.000854476f, 0.00016715f, 
    3.05176e-05f, -0.00016715f, 0.000636483f, -0.00194447f, 0.00505184f, -0.0115199f, 0.0235147f, -0.0435406f, 0.0738263f, -0.115425f, 0.167266f, -0.225541f, 0.283798f, -0.333944f, 0.367988f, -0.380056f, 0.367988f, -0.333944f, 0.283798f, -0.225541f, 0.167266f, -0.115425f, 0.0738263f, -0.0435406f, 0.0235147f, -0.0115199f, 0.00505184f, -0.00194447f, 0.000636483f, -0.00016715f, 3.05176e-05f };
    
#endif //VIGRA_WIGNER_MATRIX_REFERENCE_HXX
