# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-9243 (mapserver)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64813);
 script_cve_id("CVE-2009-0840", "CVE-2009-0839", "CVE-2009-0841", "CVE-2009-0842", "CVE-2009-0843", "CVE-2009-1176", "CVE-2009-1177");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Fedora Core 10 FEDORA-2009-9243 (mapserver)");

 desc = "The remote host is missing an update to mapserver
announced via advisory FEDORA-2009-9243.

Changelog:
* Changing imagepath and imageurl no longer allowed via URL (#1836)
* New fix for incomplete CVE-2009-0840 security fix made in 5.2.2 (#2943)
* Fixed seg fault if font not found with label ANGLE FOLLOW (#2973)

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update mapserver' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-9243

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-9243 (mapserver)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"mapserver", rpm:"mapserver~5.2.3~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mapserver-java", rpm:"mapserver-java~5.2.3~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mapserver-perl", rpm:"mapserver-perl~5.2.3~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mapserver-python", rpm:"mapserver-python~5.2.3~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mapserver", rpm:"php-mapserver~5.2.3~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mapserver-debuginfo", rpm:"mapserver-debuginfo~5.2.3~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
