###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_foswiki_detect.nasl 2120 2009-05-09 15:37:24Z may $
#
# Foswiki Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800612);
  script_version("Revision: 1.0");
  script_tag(name:"risk_factor", value:"None");
  script_name("Foswiki Version Detection");
  desc = "

  Overview: This script detects the installed version of Foswiki and
  sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set Version of Foswiki in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes", "http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

foswikiPort = get_http_port(default:80);

if(!foswikiPort){
  foswikiPort = 80;
}

if(!get_port_state(foswikiPort)){
  exit(0);
}

foreach dir (make_list("/foswiki", "/", cgi_dirs()))
{
  sndReq = http_get(item:dir + "/bin/view/foswiki/WebHome", port:foswikiPort);
  rcvRes = http_send_recv(port:foswikiPort, data:sndReq);
  if("Powered by Foswiki" >< rcvRes )
  {
    foswikiVer = eregmatch(pattern:"Foswiki-([0-9.]+),", string:rcvRes);
    if(foswikiVer[1] != NULL)
    {
      set_kb_item(name:"www/" + foswikiPort + "/Foswiki", value:foswikiVer[1] +
                      " under " + dir);
      security_note(data:"Foswiki version " + foswikiVer[1] + " running at" + 
                         " location " + dir +  " was detected on the host");
    }
  }
}
