/*
 * QuteCom, a voice over Internet phone
 * Copyright (C) 2010 Mbdsys
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "QtCreditWidget.h"

#include "ui_CreditWidget.h"

#include <presentation/qt/QtNoQuteComAlert.h>
#include <presentation/qt/QtQuteCom.h>
#include <presentation/qt/config/QtQuteComConfigDialog.h>

#include <model/account/SipAccount.h>
#include <model/profile/UserProfile.h>
#include <model/phoneline/IPhoneLine.h>
#include <model/webservices/url/WsUrl.h>

#include <control/CQuteCom.h>
#include <control/profile/CUserProfile.h>
#include <control/profile/CUserProfileHandler.h>



#include <qtutil/LanguageChangeEventFilter.h>
#include <qtutil/SafeConnect.h>

#include <util/SafeDelete.h>

#include <QtGui/QtGui>

QtCreditWidget::QtCreditWidget(QWidget * parent)
	: QObject(parent)
	, _cQuteCom(0)
	, _userProfile(0) {

	_creditWidget = new QWidget(parent);

	_ui = new Ui::CreditWidget();
	_ui->setupUi(_creditWidget);

	SAFE_CONNECT(_ui->callForwardButton, SIGNAL(clicked()), SLOT(callForwardModeClicked()));
	SAFE_CONNECT(_ui->buyCreditsButton, SIGNAL(clicked()), SLOT(buyCreditsClicked()));

	//voiceMailButton
	SAFE_CONNECT(_ui->voiceMailButton, SIGNAL(clicked()), SLOT(voiceMailClicked()));

	LANGUAGE_CHANGE(_creditWidget);
}

QtCreditWidget::~QtCreditWidget() {
	OWSAFE_DELETE(_ui);
}

void QtCreditWidget::init(CQuteCom* cQuteCom, UserProfile* userProfile) {
	_cQuteCom = cQuteCom;
	_userProfile = userProfile;
	bool isQuteCom = _userProfile->hasQuteComAccount();
	_ui->callForwardLabel->setVisible(isQuteCom);
	_ui->callForwardButton->setVisible(isQuteCom);
	_ui->buyCreditsButton->setVisible(isQuteCom);
}

QWidget * QtCreditWidget::getWidget() const {
	return _creditWidget;
}

void QtCreditWidget::updatePresentation() {
	if (!_callForwardMode.isEmpty()) {
		_ui->callForwardLabel->setText(_callForwardMode);
	}
}

void QtCreditWidget::setCallForwardMode(const QString & callForwardMode) {
	_callForwardMode = callForwardMode;
	updatePresentation();
}

void QtCreditWidget::buyCreditsClicked() {
	Q_ASSERT(_userProfile->hasQuteComAccount());
	WsUrl::showQuteComBuyQuteComs();
}

void QtCreditWidget::callForwardModeClicked() {
	Q_ASSERT(_userProfile->hasQuteComAccount());
	QtQuteComConfigDialog* dialog = QtQuteComConfigDialog::showInstance(*_cQuteCom);
	dialog->showCallForwardPage();
}

void QtCreditWidget::languageChanged() {
	_ui->retranslateUi(_creditWidget);
	updatePresentation();
}

void QtCreditWidget::voiceMailClicked() {
	IPhoneLine * phoneLine = _userProfile->getActivePhoneLine();
	if (phoneLine) {
		phoneLine->makeCall(_userProfile->getSipAccount()->getVoicemailNumber());
	}
}
