/*
 *   Copyright (C) 2008, 2009 Nicolas Vion <nico@yojik.eu>
 *
 *   This file is part of Swac-scan.
 * 
 *   Swac-scan is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   Swac-scan is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with Swac-scan.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <iostream>
#include <glibmm.h>
#include "tag.hh"
#include "stringutils.hh"

Tag::~Tag() {
}

std::string Tag::get_filename() {
	return filename;
}

bool Tag::is_standard_vorbis_comment_field(std::string const field) {
	return 
		(field == "title") or
		(field == "version") or
		(field == "album") or
		(field == "tracknumber") or
		(field == "artist") or
		(field == "performer") or
		(field == "copyright") or
		(field == "license") or
		(field == "organization") or
		(field == "description") or
		(field == "genre") or
		(field == "date") or
		(field == "location") or
		(field == "contact") or
		(field == "isrc");
}

void Tag::add_vector(std::string const field, std::string const value, bool const exclude_standards_fields) {
	std::string f = StringUtils::lower(field);
	if (!exclude_standards_fields or !is_standard_vorbis_comment_field(f))
		fields.insert(std::pair<std::string, std::string> (f, StringUtils::strip_slashes(StringUtils::chomp(value))));
}

void Tag::add_vector(std::string const vector, bool const ignore_standards_fields) {
	unsigned int pos = vector.find_first_of("=");
	if (pos != std::string::npos)
		add_vector(vector.substr(0, pos), vector.substr(pos + 1), ignore_standards_fields);
}

void Tag::print() {
	std::cout << "[" << filename << "]" << std::endl;
	for(ListFields::iterator it = fields.begin(); it != fields.end(); it++) {
		std::cout << it->first << "=" << it->second << std::endl;
	} 
	std::cout << std::endl;
}

bool Tag::extract_from_file(std::string const path, bool const ignore_standards_fields) {
	filename = path;
	return true;
}


