/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.tools;

import net.tinyos.message.Message;

public class PrintfMsg
extends Message {
    public static final int DEFAULT_MESSAGE_SIZE = 28;
    public static final int AM_TYPE = 100;

    public PrintfMsg() {
        super(28);
        this.amTypeSet(100);
    }

    public PrintfMsg(int n) {
        super(n);
        this.amTypeSet(100);
    }

    public PrintfMsg(int n, int n2) {
        super(n, n2);
        this.amTypeSet(100);
    }

    public PrintfMsg(byte[] byArray) {
        super(byArray);
        this.amTypeSet(100);
    }

    public PrintfMsg(byte[] byArray, int n) {
        super(byArray, n);
        this.amTypeSet(100);
    }

    public PrintfMsg(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
        this.amTypeSet(100);
    }

    public PrintfMsg(Message message, int n) {
        super(message, n, 28);
        this.amTypeSet(100);
    }

    public PrintfMsg(Message message, int n, int n2) {
        super(message, n, n2);
        this.amTypeSet(100);
    }

    public String toString() {
        String string = "Message <PrintfMsg> \n";
        try {
            string = string + "  [buffer=";
            for (int i = 0; i < 28; ++i) {
                string = string + "0x" + Long.toHexString(this.getElement_buffer(i) & 0xFF) + " ";
            }
            string = string + "]\n";
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return string;
    }

    public static boolean isSigned_buffer() {
        return false;
    }

    public static boolean isArray_buffer() {
        return true;
    }

    public static int offset_buffer(int n) {
        int n2 = 0;
        if (n < 0 || n >= 28) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (n2 += 0 + n * 8) / 8;
    }

    public static int offsetBits_buffer(int n) {
        int n2 = 0;
        if (n < 0 || n >= 28) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return n2 += 0 + n * 8;
    }

    public short[] get_buffer() {
        short[] sArray = new short[28];
        for (int i = 0; i < PrintfMsg.numElements_buffer(0); ++i) {
            sArray[i] = this.getElement_buffer(i);
        }
        return sArray;
    }

    public void set_buffer(short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            this.setElement_buffer(i, sArray[i]);
        }
    }

    public short getElement_buffer(int n) {
        return (short)this.getUIntBEElement(PrintfMsg.offsetBits_buffer(n), 8);
    }

    public void setElement_buffer(int n, short s) {
        this.setUIntBEElement(PrintfMsg.offsetBits_buffer(n), 8, s);
    }

    public static int totalSize_buffer() {
        return 28;
    }

    public static int totalSizeBits_buffer() {
        return 224;
    }

    public static int elementSize_buffer() {
        return 1;
    }

    public static int elementSizeBits_buffer() {
        return 8;
    }

    public static int numDimensions_buffer() {
        return 1;
    }

    public static int numElements_buffer() {
        return 28;
    }

    public static int numElements_buffer(int n) {
        int[] nArray = new int[]{28};
        if (n < 0 || n >= 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (nArray[n] == 0) {
            throw new IllegalArgumentException("Array dimension " + n + " has unknown size");
        }
        return nArray[n];
    }

    public void setString_buffer(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2; ++n) {
            this.setElement_buffer(n, (short)string.charAt(n));
        }
        this.setElement_buffer(n, (short)0);
    }

    public String getString_buffer() {
        int n;
        char[] cArray = new char[Math.min(512, 28)];
        for (n = 0; n < cArray.length && (char)this.getElement_buffer(n) != '\u0000'; ++n) {
            cArray[n] = (char)this.getElement_buffer(n);
        }
        return new String(cArray, 0, n);
    }
}

