/*
 * Copyright 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include "upmpreprocessor.h"
/**
   没有配置文件，即为新用户,按照主板配置列表进行恢复。
 */
#include "global-define.h"
UpmPreprocessor::UpmPreprocessor(QObject *parent)
{
    readModalias();
    readCpuType();
}

UpmPreprocessor::~UpmPreprocessor()
{

}

void UpmPreprocessor::start()
{
    preprocessPowerMode();
}

bool UpmPreprocessor::i2cEnable()
{
    static int ret = -1;
    if (ret > -1) {
        return ret;
    }

    ret = checkConf(UPM_GLOBAL_CONFIG, UPM_POWER_IIC_SCHEMA,
                    UPM_POWER_MODE_BALANCE_KEY);
    return ret;
}

bool UpmPreprocessor::pciEnable()
{
    static int ret = -1;
    if (ret > -1) {
        return ret;
    }

    ret = checkConf(UPM_GLOBAL_CONFIG, UPM_POWER_PCI_SCHEMA,
                    UPM_POWER_MODE_BALANCE_KEY);
    return ret;
}

bool UpmPreprocessor::sataEnable()
{
    static int ret = -1;
    if (ret > -1) {
        return ret;
    }

    ret = checkConf(UPM_GLOBAL_CONFIG, UPM_POWER_SATA_SCHEMA,
                    UPM_POWER_MODE_BALANCE_KEY);
    return ret;
}

void UpmPreprocessor::preprocessPowerMode()
{
    QGSettings settings(POWER_MANAGER_SETTINGS);
    if (settings.get(PRE_POWER_MODE).toBool()) {
        return;
    }

    QString filePath = QStandardPaths::locate(QStandardPaths::ConfigLocation,
                                              QStringLiteral("ukui-power-manager.conf"));


    settings.set(PRE_POWER_MODE, true);
    QFileInfo fileInfo(filePath);
    if (fileInfo.isFile()) {
        return;
    }

    QStringList boards = readConfig(UPM_GLOBAL_CONFIG, UPM_POWER_MODE_BALANCE_SCHEMA,
                                    UPM_POWER_MODE_BALANCE_KEY).toString().split(",");

    Q_FOREACH (const QString &str, boards) {
        if (m_modalias.contains(str) && !str.isEmpty()) {
            settings.set(POWER_POLICY_AC, Upm::powerMode::Balance);
            settings.set(POWER_POLICY_BATTERY, Upm::powerMode::Balance);
            break;
        }
    }
}

bool UpmPreprocessor::checkConf(QString file, QString group, QString key)
{
    QStringList boards = readConfig(file, group, key).toString().split(",");

    Q_FOREACH (const QString &str, boards) {
        if (m_modalias.contains(str) && !str.isEmpty()) {
            return true;
        }
    }
    return false;
}


void UpmPreprocessor::readModalias()
{
    QFile file;
    QString filePath = UPM_MODALIAS_PATH;

    file.setFileName(filePath);
    if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
        return;

    QTextStream pstream(&file);
    m_modalias = pstream.readAll();
    file.close();
}


void UpmPreprocessor::readCpuType()
{
    QFile file;
    QString filePath = UPM_CPU_INFO_PATH;

    file.setFileName(filePath);
    if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
        return;

    QTextStream pstream(&file);
    m_cpuType = pstream.readAll();
    file.close();
}


QVariant UpmPreprocessor::readConfig(QString file, QString group, QString key)
{
    QVariant ret;
    QSettings settings(file, QSettings::IniFormat);
    settings.beginGroup(group);
    ret = settings.value(key);
    settings.endGroup();
    settings.sync();

    return ret;
}



QString UpmPreprocessor::getBrightnessNode()
{
    QStringList boardNames = readConfig(
                UPM_GLOBAL_CONFIG, UPM_LENOVO_BACKLIGHT,
                UPM_LENOVO_BOARD_NAME_KEY).toString().split(",");

    Q_FOREACH (const QString &str, boardNames) {
        if (m_modalias.contains(str) && !str.isEmpty()) {
            return UPM_LENOVO_BACKLIGHT;
        }
    }

    QStringList cpuAndNodes = {"ZHAOXIN:acpi_video0",
                               "loongson:loongson-gpu",
                               "Phytium:ec_bl"};

    Q_FOREACH (const QString &str, cpuAndNodes) {
        QStringList cpuAndNode = str.split(":");
        if (m_cpuType.contains(cpuAndNode[0], Qt::CaseInsensitive)) {
            return cpuAndNode[1];
        }
    }

    return QString();
}
