/*****************************************************************************

	unsort - reorder files semi-randomly
	Copyright (C) 2008  Wessel Dankers <wsl@fruit.je>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.

	$Id: merge.c 1332 2008-06-10 20:01:01Z wsl $
	$URL: http://rot.zo.oi/svn/wsl/src/unsort/merge.c $

*****************************************************************************/

#include <stdlib.h>
#include <math.h>

#include <stdio.h>
#include <stdint.h>
#include <inttypes.h>

#include "filebuf.h"
#include "merge.h"

static int cmp(filebuf_t *a, filebuf_t *b) {
	uint64_t av, bv, an, bn;
	an = a->count;
	if(!an)
		return 1;
	bn = b->count;
	if(!bn)
		return -1;
	av = (UINT64_C(1) + UINT64_C(2) * (uint64_t)a->cursor) * bn;
	bv = (UINT64_C(1) + UINT64_C(2) * (uint64_t)b->cursor) * an;
	if(av < bv)
		return -1;
	if(av > bv)
		return 1;
	return a < b ? -1 : a > b ? 1 : 0;
}

static void merge_update(filebuf_t **dd, uint32_t count, uint32_t o) {
	filebuf_t *d, *d1, *d2;
	uint32_t o1, o2;

	if(!count)
		return;

	d = dd[o];

	for(;;) {
		o1 = o * 2 + 1;
		if(o1 >= count)
			break;
		d1 = dd[o1];

		o2 = o * 2 + 2;
		if(o2 < count) {
			d2 = dd[o2];
			if(cmp(d2, d1) < 0) {
				o1 = o2;
				d1 = d2;
			}
		}

		if(cmp(d, d1) < 0)
			break;

		dd[o1] = d;
		dd[o] = d1;
		o = o1;
	}
}

void merge(filebuf_t **dd, uint32_t count, uint32_t *src, uint32_t *dst) {
	uint32_t u, cur;
	filebuf_t *d;

	if(!dd || !count)
		return;

	for(u = count / 2; u; u--)
		merge_update(dd, count, u);
	merge_update(dd, count, u);

	for(;;) {
		d = *dd;
		cur = d->cursor;
		if(cur == d->count)
			break;
		dst[d->start + cur] = src ? *src++ : u++;
		d->cursor = cur + 1;
		merge_update(dd, count, 0);
	}
}
