/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef RAWPIXMAP_H
#define RAWPIXMAP_H
#include <vdk/vdkobj.h>
#include <vdk/rawobj.h>
class VDKObject;
class VDKForm;
/*!
  \class VDKRawPixmap
  \brief Provides a raw pixmap
 */
class VDKRawPixmap : public VDKRawObject
{
 protected:
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GtkStyle  *style;
  int w,h;
  VDKPoint lastDraw;
 public:
  /*!
    Constructor
    \param owner
    \param fixfile
   */
  VDKRawPixmap(VDKObject* owner, char* pixfile);
  /*!
    Constructor
    \param owner
    \param fixdata
   */
  VDKRawPixmap(VDKObject* owner, char** pixdata);
  /*!
    Destructor
   */
  virtual ~VDKRawPixmap();
  /*!
    GdkPixmap* conversion
  */
  operator GdkPixmap*() { return pixmap; }
  GdkPixmap* AsGdkPixmap() { return pixmap; }
  /*!
    Returns pixmap mask
   */
  GdkBitmap* Mask() { return mask; }
  /*!
    Returns pixmap style
   */
  GtkStyle*  Style() { return style; }
  /*!
    Paints the pixmap on owner
    \param x x coordinate
    \param y y coordinate
    \par Tip
    Leaving x and y to 0 value will paint pixmap on the last position
   */
  void Paint(int x, int y);
  /*!
    \internal
   */
  void Paint(bool lastdraw=true, GdkWindow* window=0, int x = 0, int y = 0);
  /*!
    Return pixmap width in pixel
   */
  int Width() { return w; }
  /*!
    Return pixmap height in pixel
   */
  int Height() { return h; }
};

#endif



