/* 
 * Copyright 2009-2011 The VOTCA Development Team (http://www.votca.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef _topologymap_H
#define	_topologymap_H

#include "map.h"
#include "topology.h"
#include <vector>

namespace votca { namespace csg {
using namespace votca::tools;

using namespace std;

class TopologyMap 
{
public:
    ~TopologyMap();
    
    TopologyMap(Topology *in, Topology *out);
    
    void AddMoleculeMap(Map *map);

    void Apply();
    
private:
    Topology *_in;
    Topology *_out;
    
    typedef vector<Map *> MapContainer;
    MapContainer _maps;
};

inline TopologyMap::TopologyMap(Topology *in, Topology *out)
    : _in(in), _out(out) {}
    
inline void TopologyMap::AddMoleculeMap(Map *map)
{
        _maps.push_back(map);
}

}}

#endif	/* _topologymap_H */

