// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_gles_3_2_autogen.cpp:
//   Capture functions for the OpenGL ES 3.2 entry points.

#include "libANGLE/capture_gles_3_2_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/FrameCapture.h"
#include "libANGLE/gl_enum_utils.h"
#include "libANGLE/validationES32.h"

using namespace angle;

namespace gl
{

CallCapture CaptureBlendBarrier(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(gl::EntryPoint::BlendBarrier, std::move(paramBuffer));
}

CallCapture CaptureBlendEquationSeparatei(const State &glState,
                                          bool isCallValid,
                                          GLuint buf,
                                          GLenum modeRGB,
                                          GLenum modeAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("modeRGB", GLenumGroup::BlendEquationModeEXT, ParamType::TGLenum,
                             modeRGB);
    paramBuffer.addEnumParam("modeAlpha", GLenumGroup::BlendEquationModeEXT, ParamType::TGLenum,
                             modeAlpha);

    return CallCapture(gl::EntryPoint::BlendEquationSeparatei, std::move(paramBuffer));
}

CallCapture CaptureBlendEquationi(const State &glState, bool isCallValid, GLuint buf, GLenum mode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("mode", GLenumGroup::BlendEquationModeEXT, ParamType::TGLenum, mode);

    return CallCapture(gl::EntryPoint::BlendEquationi, std::move(paramBuffer));
}

CallCapture CaptureBlendFuncSeparatei(const State &glState,
                                      bool isCallValid,
                                      GLuint buf,
                                      GLenum srcRGB,
                                      GLenum dstRGB,
                                      GLenum srcAlpha,
                                      GLenum dstAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("srcRGB", GLenumGroup::BlendingFactor, ParamType::TGLenum, srcRGB);
    paramBuffer.addEnumParam("dstRGB", GLenumGroup::BlendingFactor, ParamType::TGLenum, dstRGB);
    paramBuffer.addEnumParam("srcAlpha", GLenumGroup::BlendingFactor, ParamType::TGLenum, srcAlpha);
    paramBuffer.addEnumParam("dstAlpha", GLenumGroup::BlendingFactor, ParamType::TGLenum, dstAlpha);

    return CallCapture(gl::EntryPoint::BlendFuncSeparatei, std::move(paramBuffer));
}

CallCapture CaptureBlendFunci(const State &glState,
                              bool isCallValid,
                              GLuint buf,
                              GLenum src,
                              GLenum dst)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("src", GLenumGroup::BlendingFactor, ParamType::TGLenum, src);
    paramBuffer.addEnumParam("dst", GLenumGroup::BlendingFactor, ParamType::TGLenum, dst);

    return CallCapture(gl::EntryPoint::BlendFunci, std::move(paramBuffer));
}

CallCapture CaptureColorMaski(const State &glState,
                              bool isCallValid,
                              GLuint index,
                              GLboolean r,
                              GLboolean g,
                              GLboolean b,
                              GLboolean a)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("r", ParamType::TGLboolean, r);
    paramBuffer.addValueParam("g", ParamType::TGLboolean, g);
    paramBuffer.addValueParam("b", ParamType::TGLboolean, b);
    paramBuffer.addValueParam("a", ParamType::TGLboolean, a);

    return CallCapture(gl::EntryPoint::ColorMaski, std::move(paramBuffer));
}

CallCapture CaptureCopyImageSubData(const State &glState,
                                    bool isCallValid,
                                    GLuint srcName,
                                    GLenum srcTarget,
                                    GLint srcLevel,
                                    GLint srcX,
                                    GLint srcY,
                                    GLint srcZ,
                                    GLuint dstName,
                                    GLenum dstTarget,
                                    GLint dstLevel,
                                    GLint dstX,
                                    GLint dstY,
                                    GLint dstZ,
                                    GLsizei srcWidth,
                                    GLsizei srcHeight,
                                    GLsizei srcDepth)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("srcName", ParamType::TGLuint, srcName);
    paramBuffer.addEnumParam("srcTarget", GLenumGroup::CopyBufferSubDataTarget, ParamType::TGLenum,
                             srcTarget);
    paramBuffer.addValueParam("srcLevel", ParamType::TGLint, srcLevel);
    paramBuffer.addValueParam("srcX", ParamType::TGLint, srcX);
    paramBuffer.addValueParam("srcY", ParamType::TGLint, srcY);
    paramBuffer.addValueParam("srcZ", ParamType::TGLint, srcZ);
    paramBuffer.addValueParam("dstName", ParamType::TGLuint, dstName);
    paramBuffer.addEnumParam("dstTarget", GLenumGroup::CopyBufferSubDataTarget, ParamType::TGLenum,
                             dstTarget);
    paramBuffer.addValueParam("dstLevel", ParamType::TGLint, dstLevel);
    paramBuffer.addValueParam("dstX", ParamType::TGLint, dstX);
    paramBuffer.addValueParam("dstY", ParamType::TGLint, dstY);
    paramBuffer.addValueParam("dstZ", ParamType::TGLint, dstZ);
    paramBuffer.addValueParam("srcWidth", ParamType::TGLsizei, srcWidth);
    paramBuffer.addValueParam("srcHeight", ParamType::TGLsizei, srcHeight);
    paramBuffer.addValueParam("srcDepth", ParamType::TGLsizei, srcDepth);

    return CallCapture(gl::EntryPoint::CopyImageSubData, std::move(paramBuffer));
}

CallCapture CaptureDebugMessageCallback(const State &glState,
                                        bool isCallValid,
                                        GLDEBUGPROC callback,
                                        const void *userParam)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("callback", ParamType::TGLDEBUGPROC, callback);

    ParamCapture userParamParam("userParam", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, userParam, &userParamParam.value);
    CaptureDebugMessageCallback_userParam(glState, isCallValid, callback, userParam,
                                          &userParamParam);
    paramBuffer.addParam(std::move(userParamParam));

    return CallCapture(gl::EntryPoint::DebugMessageCallback, std::move(paramBuffer));
}

CallCapture CaptureDebugMessageControl(const State &glState,
                                       bool isCallValid,
                                       GLenum source,
                                       GLenum type,
                                       GLenum severity,
                                       GLsizei count,
                                       const GLuint *ids,
                                       GLboolean enabled)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("source", GLenumGroup::DebugSource, ParamType::TGLenum, source);
    paramBuffer.addEnumParam("type", GLenumGroup::DebugType, ParamType::TGLenum, type);
    paramBuffer.addEnumParam("severity", GLenumGroup::DebugSeverity, ParamType::TGLenum, severity);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture idsParam("ids", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, ids, &idsParam.value);
    CaptureDebugMessageControl_ids(glState, isCallValid, source, type, severity, count, ids,
                                   enabled, &idsParam);
    paramBuffer.addParam(std::move(idsParam));

    paramBuffer.addValueParam("enabled", ParamType::TGLboolean, enabled);

    return CallCapture(gl::EntryPoint::DebugMessageControl, std::move(paramBuffer));
}

CallCapture CaptureDebugMessageInsert(const State &glState,
                                      bool isCallValid,
                                      GLenum source,
                                      GLenum type,
                                      GLuint id,
                                      GLenum severity,
                                      GLsizei length,
                                      const GLchar *buf)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("source", GLenumGroup::DebugSource, ParamType::TGLenum, source);
    paramBuffer.addEnumParam("type", GLenumGroup::DebugType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addEnumParam("severity", GLenumGroup::DebugSeverity, ParamType::TGLenum, severity);
    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    ParamCapture bufParam("buf", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, buf, &bufParam.value);
    CaptureDebugMessageInsert_buf(glState, isCallValid, source, type, id, severity, length, buf,
                                  &bufParam);
    paramBuffer.addParam(std::move(bufParam));

    return CallCapture(gl::EntryPoint::DebugMessageInsert, std::move(paramBuffer));
}

CallCapture CaptureDisablei(const State &glState, bool isCallValid, GLenum target, GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::EnableCap, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture(gl::EntryPoint::Disablei, std::move(paramBuffer));
}

CallCapture CaptureDrawElementsBaseVertex(const State &glState,
                                          bool isCallValid,
                                          PrimitiveMode modePacked,
                                          GLsizei count,
                                          DrawElementsType typePacked,
                                          const void *indices,
                                          GLint basevertex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
    CaptureDrawElementsBaseVertex_indices(glState, isCallValid, modePacked, count, typePacked,
                                          indices, basevertex, &indicesParam);
    paramBuffer.addParam(std::move(indicesParam));

    paramBuffer.addValueParam("basevertex", ParamType::TGLint, basevertex);

    return CallCapture(gl::EntryPoint::DrawElementsBaseVertex, std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstancedBaseVertex(const State &glState,
                                                   bool isCallValid,
                                                   PrimitiveMode modePacked,
                                                   GLsizei count,
                                                   DrawElementsType typePacked,
                                                   const void *indices,
                                                   GLsizei instancecount,
                                                   GLint basevertex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
    CaptureDrawElementsInstancedBaseVertex_indices(glState, isCallValid, modePacked, count,
                                                   typePacked, indices, instancecount, basevertex,
                                                   &indicesParam);
    paramBuffer.addParam(std::move(indicesParam));

    paramBuffer.addValueParam("instancecount", ParamType::TGLsizei, instancecount);
    paramBuffer.addValueParam("basevertex", ParamType::TGLint, basevertex);

    return CallCapture(gl::EntryPoint::DrawElementsInstancedBaseVertex, std::move(paramBuffer));
}

CallCapture CaptureDrawRangeElementsBaseVertex(const State &glState,
                                               bool isCallValid,
                                               PrimitiveMode modePacked,
                                               GLuint start,
                                               GLuint end,
                                               GLsizei count,
                                               DrawElementsType typePacked,
                                               const void *indices,
                                               GLint basevertex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("start", ParamType::TGLuint, start);
    paramBuffer.addValueParam("end", ParamType::TGLuint, end);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
    CaptureDrawRangeElementsBaseVertex_indices(glState, isCallValid, modePacked, start, end, count,
                                               typePacked, indices, basevertex, &indicesParam);
    paramBuffer.addParam(std::move(indicesParam));

    paramBuffer.addValueParam("basevertex", ParamType::TGLint, basevertex);

    return CallCapture(gl::EntryPoint::DrawRangeElementsBaseVertex, std::move(paramBuffer));
}

CallCapture CaptureEnablei(const State &glState, bool isCallValid, GLenum target, GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::EnableCap, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture(gl::EntryPoint::Enablei, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTexture(const State &glState,
                                      bool isCallValid,
                                      GLenum target,
                                      GLenum attachment,
                                      TextureID texturePacked,
                                      GLint level)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLenumGroup::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);

    return CallCapture(gl::EntryPoint::FramebufferTexture, std::move(paramBuffer));
}

CallCapture CaptureGetDebugMessageLog(const State &glState,
                                      bool isCallValid,
                                      GLuint count,
                                      GLsizei bufSize,
                                      GLenum *sources,
                                      GLenum *types,
                                      GLuint *ids,
                                      GLenum *severities,
                                      GLsizei *lengths,
                                      GLchar *messageLog,
                                      GLuint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("count", ParamType::TGLuint, count);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture sourcesParam("sources", ParamType::TGLenumPointer);
    InitParamValue(ParamType::TGLenumPointer, sources, &sourcesParam.value);
    CaptureGetDebugMessageLog_sources(glState, isCallValid, count, bufSize, sources, types, ids,
                                      severities, lengths, messageLog, &sourcesParam);
    paramBuffer.addParam(std::move(sourcesParam));

    ParamCapture typesParam("types", ParamType::TGLenumPointer);
    InitParamValue(ParamType::TGLenumPointer, types, &typesParam.value);
    CaptureGetDebugMessageLog_types(glState, isCallValid, count, bufSize, sources, types, ids,
                                    severities, lengths, messageLog, &typesParam);
    paramBuffer.addParam(std::move(typesParam));

    ParamCapture idsParam("ids", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, ids, &idsParam.value);
    CaptureGetDebugMessageLog_ids(glState, isCallValid, count, bufSize, sources, types, ids,
                                  severities, lengths, messageLog, &idsParam);
    paramBuffer.addParam(std::move(idsParam));

    ParamCapture severitiesParam("severities", ParamType::TGLenumPointer);
    InitParamValue(ParamType::TGLenumPointer, severities, &severitiesParam.value);
    CaptureGetDebugMessageLog_severities(glState, isCallValid, count, bufSize, sources, types, ids,
                                         severities, lengths, messageLog, &severitiesParam);
    paramBuffer.addParam(std::move(severitiesParam));

    ParamCapture lengthsParam("lengths", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, lengths, &lengthsParam.value);
    CaptureGetDebugMessageLog_lengths(glState, isCallValid, count, bufSize, sources, types, ids,
                                      severities, lengths, messageLog, &lengthsParam);
    paramBuffer.addParam(std::move(lengthsParam));

    ParamCapture messageLogParam("messageLog", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, messageLog, &messageLogParam.value);
    CaptureGetDebugMessageLog_messageLog(glState, isCallValid, count, bufSize, sources, types, ids,
                                         severities, lengths, messageLog, &messageLogParam);
    paramBuffer.addParam(std::move(messageLogParam));

    ParamCapture returnValueCapture("returnValue", ParamType::TGLuint);
    InitParamValue(ParamType::TGLuint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::GetDebugMessageLog, std::move(paramBuffer));
}

CallCapture CaptureGetGraphicsResetStatus(const State &glState,
                                          bool isCallValid,
                                          GLenum returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture returnValueCapture("returnValue", ParamType::TGLenum);
    InitParamValue(ParamType::TGLenum, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::GetGraphicsResetStatus, std::move(paramBuffer));
}

CallCapture CaptureGetObjectLabel(const State &glState,
                                  bool isCallValid,
                                  GLenum identifier,
                                  GLuint name,
                                  GLsizei bufSize,
                                  GLsizei *length,
                                  GLchar *label)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("identifier", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             identifier);
    paramBuffer.addValueParam("name", ParamType::TGLuint, name);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetObjectLabel_length(glState, isCallValid, identifier, name, bufSize, length, label,
                                 &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture labelParam("label", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, label, &labelParam.value);
    CaptureGetObjectLabel_label(glState, isCallValid, identifier, name, bufSize, length, label,
                                &labelParam);
    paramBuffer.addParam(std::move(labelParam));

    return CallCapture(gl::EntryPoint::GetObjectLabel, std::move(paramBuffer));
}

CallCapture CaptureGetObjectPtrLabel(const State &glState,
                                     bool isCallValid,
                                     const void *ptr,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLchar *label)
{
    ParamBuffer paramBuffer;

    ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, ptr, &ptrParam.value);
    CaptureGetObjectPtrLabel_ptr(glState, isCallValid, ptr, bufSize, length, label, &ptrParam);
    paramBuffer.addParam(std::move(ptrParam));

    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetObjectPtrLabel_length(glState, isCallValid, ptr, bufSize, length, label,
                                    &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture labelParam("label", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, label, &labelParam.value);
    CaptureGetObjectPtrLabel_label(glState, isCallValid, ptr, bufSize, length, label, &labelParam);
    paramBuffer.addParam(std::move(labelParam));

    return CallCapture(gl::EntryPoint::GetObjectPtrLabel, std::move(paramBuffer));
}

CallCapture CaptureGetPointerv(const State &glState, bool isCallValid, GLenum pname, void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::GetPointervPName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
    InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
    CaptureGetPointerv_params(glState, isCallValid, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetPointerv, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIiv(const State &glState,
                                          bool isCallValid,
                                          SamplerID samplerPacked,
                                          GLenum pname,
                                          GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::SamplerParameterName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetSamplerParameterIiv_params(glState, isCallValid, samplerPacked, pname, params,
                                         &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetSamplerParameterIiv, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIuiv(const State &glState,
                                           bool isCallValid,
                                           SamplerID samplerPacked,
                                           GLenum pname,
                                           GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::SamplerParameterName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetSamplerParameterIuiv_params(glState, isCallValid, samplerPacked, pname, params,
                                          &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetSamplerParameterIuiv, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIiv(const State &glState,
                                      bool isCallValid,
                                      TextureType targetPacked,
                                      GLenum pname,
                                      GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::GetTextureParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetTexParameterIiv_params(glState, isCallValid, targetPacked, pname, params,
                                     &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexParameterIiv, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIuiv(const State &glState,
                                       bool isCallValid,
                                       TextureType targetPacked,
                                       GLenum pname,
                                       GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::GetTextureParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetTexParameterIuiv_params(glState, isCallValid, targetPacked, pname, params,
                                      &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexParameterIuiv, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformfv(const State &glState,
                                 bool isCallValid,
                                 ShaderProgramID programPacked,
                                 GLint location,
                                 GLsizei bufSize,
                                 GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetnUniformfv_params(glState, isCallValid, programPacked, location, bufSize, params,
                                &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetnUniformfv, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformiv(const State &glState,
                                 bool isCallValid,
                                 ShaderProgramID programPacked,
                                 GLint location,
                                 GLsizei bufSize,
                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetnUniformiv_params(glState, isCallValid, programPacked, location, bufSize, params,
                                &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetnUniformiv, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformuiv(const State &glState,
                                  bool isCallValid,
                                  ShaderProgramID programPacked,
                                  GLint location,
                                  GLsizei bufSize,
                                  GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetnUniformuiv_params(glState, isCallValid, programPacked, location, bufSize, params,
                                 &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetnUniformuiv, std::move(paramBuffer));
}

CallCapture CaptureIsEnabledi(const State &glState,
                              bool isCallValid,
                              GLenum target,
                              GLuint index,
                              GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::EnableCap, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsEnabledi, std::move(paramBuffer));
}

CallCapture CaptureMinSampleShading(const State &glState, bool isCallValid, GLfloat value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("value", ParamType::TGLfloat, value);

    return CallCapture(gl::EntryPoint::MinSampleShading, std::move(paramBuffer));
}

CallCapture CaptureObjectLabel(const State &glState,
                               bool isCallValid,
                               GLenum identifier,
                               GLuint name,
                               GLsizei length,
                               const GLchar *label)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("identifier", GLenumGroup::ObjectIdentifier, ParamType::TGLenum,
                             identifier);
    paramBuffer.addValueParam("name", ParamType::TGLuint, name);
    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    ParamCapture labelParam("label", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, label, &labelParam.value);
    CaptureObjectLabel_label(glState, isCallValid, identifier, name, length, label, &labelParam);
    paramBuffer.addParam(std::move(labelParam));

    return CallCapture(gl::EntryPoint::ObjectLabel, std::move(paramBuffer));
}

CallCapture CaptureObjectPtrLabel(const State &glState,
                                  bool isCallValid,
                                  const void *ptr,
                                  GLsizei length,
                                  const GLchar *label)
{
    ParamBuffer paramBuffer;

    ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, ptr, &ptrParam.value);
    CaptureObjectPtrLabel_ptr(glState, isCallValid, ptr, length, label, &ptrParam);
    paramBuffer.addParam(std::move(ptrParam));

    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    ParamCapture labelParam("label", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, label, &labelParam.value);
    CaptureObjectPtrLabel_label(glState, isCallValid, ptr, length, label, &labelParam);
    paramBuffer.addParam(std::move(labelParam));

    return CallCapture(gl::EntryPoint::ObjectPtrLabel, std::move(paramBuffer));
}

CallCapture CapturePatchParameteri(const State &glState,
                                   bool isCallValid,
                                   GLenum pname,
                                   GLint value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::PatchParameterName, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("value", ParamType::TGLint, value);

    return CallCapture(gl::EntryPoint::PatchParameteri, std::move(paramBuffer));
}

CallCapture CapturePopDebugGroup(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(gl::EntryPoint::PopDebugGroup, std::move(paramBuffer));
}

CallCapture CapturePrimitiveBoundingBox(const State &glState,
                                        bool isCallValid,
                                        GLfloat minX,
                                        GLfloat minY,
                                        GLfloat minZ,
                                        GLfloat minW,
                                        GLfloat maxX,
                                        GLfloat maxY,
                                        GLfloat maxZ,
                                        GLfloat maxW)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("minX", ParamType::TGLfloat, minX);
    paramBuffer.addValueParam("minY", ParamType::TGLfloat, minY);
    paramBuffer.addValueParam("minZ", ParamType::TGLfloat, minZ);
    paramBuffer.addValueParam("minW", ParamType::TGLfloat, minW);
    paramBuffer.addValueParam("maxX", ParamType::TGLfloat, maxX);
    paramBuffer.addValueParam("maxY", ParamType::TGLfloat, maxY);
    paramBuffer.addValueParam("maxZ", ParamType::TGLfloat, maxZ);
    paramBuffer.addValueParam("maxW", ParamType::TGLfloat, maxW);

    return CallCapture(gl::EntryPoint::PrimitiveBoundingBox, std::move(paramBuffer));
}

CallCapture CapturePushDebugGroup(const State &glState,
                                  bool isCallValid,
                                  GLenum source,
                                  GLuint id,
                                  GLsizei length,
                                  const GLchar *message)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("source", GLenumGroup::DebugSource, ParamType::TGLenum, source);
    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    ParamCapture messageParam("message", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, message, &messageParam.value);
    CapturePushDebugGroup_message(glState, isCallValid, source, id, length, message, &messageParam);
    paramBuffer.addParam(std::move(messageParam));

    return CallCapture(gl::EntryPoint::PushDebugGroup, std::move(paramBuffer));
}

CallCapture CaptureReadnPixels(const State &glState,
                               bool isCallValid,
                               GLint x,
                               GLint y,
                               GLsizei width,
                               GLsizei height,
                               GLenum format,
                               GLenum type,
                               GLsizei bufSize,
                               void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLenumGroup::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::PixelType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture dataParam("data", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, data, &dataParam.value);
    CaptureReadnPixels_data(glState, isCallValid, x, y, width, height, format, type, bufSize, data,
                            &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::ReadnPixels, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIiv(const State &glState,
                                       bool isCallValid,
                                       SamplerID samplerPacked,
                                       GLenum pname,
                                       const GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::SamplerParameterName, ParamType::TGLenum, pname);

    ParamCapture paramParam("param", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, param, &paramParam.value);
    CaptureSamplerParameterIiv_param(glState, isCallValid, samplerPacked, pname, param,
                                     &paramParam);
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture(gl::EntryPoint::SamplerParameterIiv, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIuiv(const State &glState,
                                        bool isCallValid,
                                        SamplerID samplerPacked,
                                        GLenum pname,
                                        const GLuint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::SamplerParameterName, ParamType::TGLenum, pname);

    ParamCapture paramParam("param", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, param, &paramParam.value);
    CaptureSamplerParameterIuiv_param(glState, isCallValid, samplerPacked, pname, param,
                                      &paramParam);
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture(gl::EntryPoint::SamplerParameterIuiv, std::move(paramBuffer));
}

CallCapture CaptureTexBuffer(const State &glState,
                             bool isCallValid,
                             GLenum target,
                             GLenum internalformat,
                             BufferID bufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::TextureTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);

    return CallCapture(gl::EntryPoint::TexBuffer, std::move(paramBuffer));
}

CallCapture CaptureTexBufferRange(const State &glState,
                                  bool isCallValid,
                                  GLenum target,
                                  GLenum internalformat,
                                  BufferID bufferPacked,
                                  GLintptr offset,
                                  GLsizeiptr size)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::TextureTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    return CallCapture(gl::EntryPoint::TexBufferRange, std::move(paramBuffer));
}

CallCapture CaptureTexParameterIiv(const State &glState,
                                   bool isCallValid,
                                   TextureType targetPacked,
                                   GLenum pname,
                                   const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureParameterName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
    CaptureTexParameterIiv_params(glState, isCallValid, targetPacked, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::TexParameterIiv, std::move(paramBuffer));
}

CallCapture CaptureTexParameterIuiv(const State &glState,
                                    bool isCallValid,
                                    TextureType targetPacked,
                                    GLenum pname,
                                    const GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureParameterName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, params, &paramsParam.value);
    CaptureTexParameterIuiv_params(glState, isCallValid, targetPacked, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::TexParameterIuiv, std::move(paramBuffer));
}

CallCapture CaptureTexStorage3DMultisample(const State &glState,
                                           bool isCallValid,
                                           TextureType targetPacked,
                                           GLsizei samples,
                                           GLenum internalformat,
                                           GLsizei width,
                                           GLsizei height,
                                           GLsizei depth,
                                           GLboolean fixedsamplelocations)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("fixedsamplelocations", ParamType::TGLboolean, fixedsamplelocations);

    return CallCapture(gl::EntryPoint::TexStorage3DMultisample, std::move(paramBuffer));
}

}  // namespace gl
