// **********************************************************************
//
// Copyright (c) 2003-2007 ZeroC, Inc. All rights reserved.
//
// This copy of Ice-E is licensed to you under the terms described in the
// ICEE_LICENSE file included in this distribution.
//
// **********************************************************************

public class Client
{
    public static int
    run(String[] args, Ice.Communicator communicator, Ice.InitializationData data, java.io.PrintStream out)
    {
        Test.RetryPrx retry = AllTests.allTests(communicator, out);
        retry.shutdown();
        return 0;
    }

    public static void
    main(String[] args)
    {
        int status = 0;
        Ice.Communicator communicator = null;

        try
        {
	    Ice.StringSeqHolder argsH = new Ice.StringSeqHolder(args);
	    Ice.InitializationData initData = new Ice.InitializationData();
	    
	    initData.properties = Ice.Util.createProperties(argsH);

	    //
	    // For this test, we want to disable retries.
	    //
	    initData.properties.setProperty("Ice.RetryIntervals", "-1");

	    //
	    // We don't want connection warnings because of the timeout test.
	    //
	    initData.properties.setProperty("Ice.Warn.Connections", "0");

	    communicator = Ice.Util.initialize(argsH, initData);
	    
            status = run(argsH.value, communicator, initData, System.out);
        }
        catch(Ice.LocalException ex)
        {
            ex.printStackTrace();
            status = 1;
        }

        if(communicator != null)
        {
            try
            {
                communicator.destroy();
            }
            catch(Ice.LocalException ex)
            {
                ex.printStackTrace();
                status = 1;
            }
        }

	System.gc();
        System.exit(status);
    }
}
